% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.FIterator.R
\name{FIterator}
\alias{FIterator}
\title{Iterator over a file.}
\description{
Creates a \code{\link{FIterator}} object to iterate over high
dimensional files.
}
\details{
Use \code{\link{HDDataset}} class to ensure the creation of a valid
\code{\link{FIterator}} object.
}
\seealso{
\code{\link{Dataset}}
}
\keyword{connection}
\keyword{datagen}
\keyword{file}
\keyword{internal}
\keyword{manip}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{FIterator$new()}}
\item \href{#method-getNext}{\code{FIterator$getNext()}}
\item \href{#method-isLast}{\code{FIterator$isLast()}}
\item \href{#method-finalize}{\code{FIterator$finalize()}}
\item \href{#method-clone}{\code{FIterator$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
Method for initializing the object arguments during runtime.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FIterator$new(config.params, chunk.size, verbose)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{config.params}}{A \link{list} of configuration options.}

\item{\code{chunk.size}}{An \link{integer} value indicating the size of chunks
taken over each iteration. By default \code{chunk.size} is defined as
10000.}

\item{\code{verbose}}{A \link{logical} value to specify if more verbosity is
needed.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-getNext"></a>}}
\if{latex}{\out{\hypertarget{method-getNext}{}}}
\subsection{Method \code{getNext()}}{
Gets the next chunk of data. Each iteration returns the same
instances (data.frame rows) as chunk.size. However, if remaining data if
less than chunk size, all the remaining data is returned. Conversely,
\link{NULL} when there is no more pending data. By default
\code{chunk.size} is defined as 10000.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FIterator$getNext()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A \link{data.frame} of \link{NULL} if all the data have been
previously returned.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-isLast"></a>}}
\if{latex}{\out{\hypertarget{method-isLast}{}}}
\subsection{Method \code{isLast()}}{
Checks if the \code{\link{FIterator}} object reached the end
of the \link{data.frame}
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FIterator$isLast()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A \link{logical} value indicating if the end of \link{data.frame}
has been reached.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-finalize"></a>}}
\if{latex}{\out{\hypertarget{method-finalize}{}}}
\subsection{Method \code{finalize()}}{
Destroys the \code{\link{FIterator}} object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FIterator$finalize()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FIterator$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
