% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/models.summaryFunction.SummaryFunction.R
\name{SummaryFunction}
\alias{SummaryFunction}
\title{Abstract class to computing performance across resamples.}
\description{
Abstract used as template to define customized metrics to
compute model performance during train.
}
\details{
This class is an archetype, so it cannot be instantiated.
}
\seealso{
\code{\link{NoProbability}}, \code{\link{UseProbability}}
}
\keyword{misc}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-SummaryFunction-new}{\code{SummaryFunction$new()}}
\item \href{#method-SummaryFunction-execute}{\code{SummaryFunction$execute()}}
\item \href{#method-SummaryFunction-getMeasures}{\code{SummaryFunction$getMeasures()}}
\item \href{#method-SummaryFunction-clone}{\code{SummaryFunction$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-SummaryFunction-new"></a>}}
\if{latex}{\out{\hypertarget{method-SummaryFunction-new}{}}}
\subsection{Method \code{new()}}{
The function carries out the initialization of parameters
during runtime.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SummaryFunction$new(measures)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{measures}}{A \link{character} vector with the measures used.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-SummaryFunction-execute"></a>}}
\if{latex}{\out{\hypertarget{method-SummaryFunction-execute}{}}}
\subsection{Method \code{execute()}}{
Abstract function used to implement the performance
calculator method. To guarantee a proper operation, this method is
automatically invoked by \code{\link{D2MCS}} framework.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SummaryFunction$execute()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-SummaryFunction-getMeasures"></a>}}
\if{latex}{\out{\hypertarget{method-SummaryFunction-getMeasures}{}}}
\subsection{Method \code{getMeasures()}}{
The function obtains the measures used to compute the
performance across resamples.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SummaryFunction$getMeasures()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A \link{character} vector of \link{NULL} if measures are not
defined.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-SummaryFunction-clone"></a>}}
\if{latex}{\out{\hypertarget{method-SummaryFunction-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SummaryFunction$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
