% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/d3m_parallel.R
\name{d3m.parallel}
\alias{d3m.parallel}
\title{Parallel Version of Two Sample Test with Distribution-Valued Data}
\usage{
d3m.parallel(cases, control, rm.mean = F, rm.var = F, paranum = 101,
  q = 2, bsn = 5000, n.core = 4, type = "SOCK", seed = c(100, 200,
  300, 400))
}
\arguments{
\item{cases}{name of case group data (matrix)}

\item{control}{names of control group data (matrix)}

\item{rm.mean}{standarize each rows of cases and control to mean=0.}

\item{rm.var}{standarize each rows of cases and control to var=1.}

\item{paranum}{the number of quatile discretization + 1. Default is discretized by 1 \%.}

\item{q}{power of Wasserstein metric. Default is q = 2.}

\item{bsn}{the number of resampling. Default is bsn = 5000.}

\item{n.core}{the number of cores to be used.}

\item{type}{choose the cluster type. "SOCK","MPI","PVM"or "NWS". Default is "SOCK". More detail information, see ?clusterMap in "parllel" and/or "snow" package.}

\item{seed}{seed for random number generator assigned for each cluster. Default is c(100,200,300,400) assuming n.core=4.}
}
\value{
result of d3m in the list format, including p-value, test statistics, data of cases, data of control. Each element of list correponds to result from each core.
}
\description{
Parallel Version of Two Sample Test with Distribution-Valued Data
}
\examples{
library(D3M)
nrep <- 12
cases <- Map(rbeta,rep(50,nrep),rep(1,nrep),rep(5,nrep))
cases <- do.call("rbind",cases)
control <- Map(rbeta,rep(50,nrep),rep(1,nrep),rep(5,nrep))
control <- do.call("rbind",control)
## do not run.
#d3m.parallel(cases,control,rm.mean = FALSE, rm.var = FALSE, bsn = 1000)
}
\author{
Yusuke Matsui & Teppei Shimamura
}

