% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/printmodid.R
\name{print.modid}
\alias{print.modid}
\title{Print Method for S3 Objects of Class \code{modid}}
\usage{
\method{print}{modid}(x, ...)
}
\arguments{
\item{x}{A S3 object of class \code{modid}.}

\item{...}{Additional arguments.}
}
\value{
A printed message reporting the number of factors and the suggested model identification items.
}
\description{
The print method for the \code{\link[=modid]{modid()}} function.
}
\examples{
\dontrun{
# Identify the DMIRT model using a three-factor EFA with modid()
# x can be a data frame with item data or item factor loadings.
# In the case of the latter, set argument 'efa' to 'FALSE'
g <- modid(x)

# Print model identification summary
print(g)
}
}
