% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DAISIE_plot_stt.R
\name{DAISIE_convert_to_classic_plot}
\alias{DAISIE_convert_to_classic_plot}
\title{Prepare input for DAISIE_stt}
\usage{
DAISIE_convert_to_classic_plot(simulation_outputs, trait_pars = NULL)
}
\arguments{
\item{simulation_outputs}{A list with matrices and vectors of simulation
produced by DAISIE_sim functions.}

\item{trait_pars}{A named list containing diversification rates considering
two trait states created by \code{\link{create_trait_pars}}:
\itemize{
  \item{[1]:A numeric with the per capita transition rate with state1}
  \item{[2]:A numeric with the per capita immigration rate with state2}
  \item{[3]:A numeric with the per capita extinction rate with state2}
  \item{[4]:A numeric with the per capita anagenesis rate with state2}
  \item{[5]:A numeric with the per capita cladogenesis rate with state2}
  \item{[6]:A numeric with the per capita transition rate with state2}
  \item{[7]:A numeric with the number of species with trait state 2 on
   mainland}
}}
}
\value{
a list with wrangled data to be used for plotting STT plots with
DAISIE_plot_stt
}
\description{
Prepare input for DAISIE_stt
}
\examples{
utils::data("islands_1type_1000reps", package = "DAISIE")
simulation_outuputs <- DAISIE:::DAISIE_convert_to_classic_plot(
islands_1type_1000reps
)


}
\seealso{
\code{\link{DAISIE_plot_stt}}, \code{\link{DAISIE_plot_sims}}
}
\keyword{internal}
