% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rm_island_colonist.R
\name{rm_island_colonist}
\alias{rm_island_colonist}
\title{Removes an island colonist from an \code{Island_tbl} object}
\usage{
rm_island_colonist(island_tbl, clade_name)
}
\arguments{
\item{island_tbl}{An instance of the \code{Island_tbl} class.}

\item{clade_name}{Character name of the colonising clade.}
}
\value{
Object of \code{Island_tbl} class
}
\description{
Removes an island colonist from an \code{Island_tbl} object
}
\examples{
phylod <- create_test_phylod(test_scenario = 1)
island_tbl <- extract_island_species(
  phylod = phylod,
  extraction_method = "min"
)
island_tbl <- rm_island_colonist(
  island_tbl = island_tbl,
  clade_name = "bird_b"
)
}
