% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/variable_dropout.R
\name{variable_dropout}
\alias{variable_dropout}
\title{Loss from Variable Dropout}
\usage{
variable_dropout(explainer, loss_function = function(observed, predicted)
  sum((observed - predicted)^2), ..., type = "raw", n_sample = 1000)
}
\arguments{
\item{explainer}{a model to be explained, preprocessed by the 'explain' function}

\item{loss_function}{a function thet will be used to assess variable importance}

\item{...}{other parameters}

\item{type}{character, type of transformation that should be applied for dropout loss. 'raw' results raw drop lossess, 'ratio' returns \code{drop_loss/drop_loss_full_model} while 'difference' returns \code{drop_loss - drop_loss_full_model}}

\item{n_sample}{number of observations that should be sampled for calculations of variable leverages}
}
\value{
An object of the class 'variable_leverage_explainer'.
It's a data frame with calculated average response.
}
\description{
Loss from Variable Dropout
}
\examples{
\dontrun{
library("breakDown")
library("randomForest")
HR_rf_model <- randomForest(left~., data = breakDown::HR_data, ntree = 100)
explainer_rf  <- explain(HR_rf_model, data = HR_data, y = HR_data$left)
vd_rf <- variable_dropout(explainer_rf, type = "raw")
vd_rf

HR_glm_model <- glm(left~., data = breakDown::HR_data, family = "binomial")
explainer_glm <- explain(HR_glm_model, data = HR_data, y = HR_data$left)
logit <- function(x) exp(x)/(1+exp(x))
vd_glm <- variable_dropout(explainer_glm, type = "raw",
                        loss_function = function(observed, predicted)
                                     sum((observed - logit(predicted))^2))
vd_glm

library("xgboost")
model_martix_train <- model.matrix(left~.-1, breakDown::HR_data)
data_train <- xgb.DMatrix(model_martix_train, label = breakDown::HR_data$left)
param <- list(max_depth = 2, eta = 1, silent = 1, nthread = 2,
              objective = "binary:logistic", eval_metric = "auc")
HR_xgb_model <- xgb.train(param, data_train, nrounds = 50)
explainer_xgb <- explain(HR_xgb_model, data = model_martix_train,
                     y = HR_data$left, label = "xgboost")
vd_xgb <- variable_dropout(explainer_xgb, type = "raw")
vd_xgb
}

}
