% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict_profile.R
\name{predict_profile}
\alias{predict_profile}
\alias{individual_profile}
\title{Instance Level Profile as Ceteris Paribus}
\usage{
predict_profile(
  explainer,
  new_observation,
  variables = NULL,
  ...,
  type = "ceteris_paribus",
  variable_splits_type = "uniform"
)

individual_profile(
  explainer,
  new_observation,
  variables = NULL,
  ...,
  type = "ceteris_paribus",
  variable_splits_type = "uniform"
)
}
\arguments{
\item{explainer}{a model to be explained, preprocessed by the \code{explain} function}

\item{new_observation}{a new observation for which predictions need to be explained}

\item{variables}{character - names of variables to be explained}

\item{...}{other parameters}

\item{type}{character, currently only the \code{ceteris_paribus} is implemented}

\item{variable_splits_type}{how variable grids shall be calculated? Use "quantiles" (default) for percentiles or "uniform" to get uniform grid of points. Will be passed to `ingredients`.}
}
\value{
An object of the class \code{ceteris_paribus_explainer}.
It's a data frame with calculated average response.
}
\description{
This function calculated individual profiles aka Ceteris Paribus Profiles.
From DALEX version 1.0 this function calls the \code{\link[ingredients]{ceteris_paribus}} from the \code{ingredients} package.
Find information how to use this function here: \url{https://pbiecek.github.io/ema/ceterisParibus.html}.
}
\examples{
new_dragon <- data.frame(year_of_birth = 200,
     height = 80,
     weight = 12.5,
     scars = 0,
     number_of_lost_teeth  = 5)

dragon_lm_model4 <- lm(life_length ~ year_of_birth + height +
                                     weight + scars + number_of_lost_teeth,
                       data = dragons)
dragon_lm_explainer4 <- explain(dragon_lm_model4, data = dragons, y = dragons$year_of_birth,
                                label = "model_4v")
dragon_lm_predict4 <- predict_profile(dragon_lm_explainer4,
                new_observation = new_dragon,
                variables = c("year_of_birth", "height", "scars"))
head(dragon_lm_predict4)
plot(dragon_lm_predict4,
    variables = c("year_of_birth", "height", "scars"))

\donttest{
library("ranger")
dragon_ranger_model4 <- ranger(life_length ~ year_of_birth + height +
                                               weight + scars + number_of_lost_teeth,
                                 data = dragons, num.trees = 50)
dragon_ranger_explainer4 <- explain(dragon_ranger_model4, data = dragons, y = dragons$year_of_birth,
                                label = "model_ranger")
dragon_ranger_predict4 <- predict_profile(dragon_ranger_explainer4,
                                           new_observation = new_dragon,
                                           variables = c("year_of_birth", "height", "scars"))
head(dragon_ranger_predict4)
plot(dragon_ranger_predict4,
    variables = c("year_of_birth", "height", "scars"))
 }

}
\references{
Explanatory Model Analysis. Explore, Explain, and Examine Predictive Models. \url{https://pbiecek.github.io/ema/}
}
