% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aspect_importance.R
\name{aspect_importance_single}
\alias{aspect_importance_single}
\alias{aspect_importance_single.explainer}
\alias{aspect_importance_single.default}
\title{Aspects importance for single aspects}
\usage{
aspect_importance_single(x, ...)

\method{aspect_importance_single}{explainer}(
  x,
  new_observation,
  N = 100,
  sample_method = "default",
  n_var = 0,
  f = 2,
  ...
)

\method{aspect_importance_single}{default}(
  x,
  data,
  predict_function = predict,
  new_observation,
  N = 100,
  label = class(x)[1],
  sample_method = "default",
  n_var = 0,
  f = 2,
  ...
)
}
\arguments{
\item{x}{an explainer created with the \code{DALEX::explain()} function
or a model to be explained.}

\item{...}{other parameters}

\item{new_observation}{selected observation with columns that corresponds to
variables used in the model, should be without target variable}

\item{N}{number of observations to be sampled (with replacement) from data}

\item{sample_method}{sampling method in \code{\link{get_sample}}}

\item{n_var}{how many non-zero coefficients for lasso fitting, if zero than
linear regression is used}

\item{f}{frequency in in \code{\link{get_sample}}}

\item{data}{dataset, it will be extracted from \code{x} if it's an explainer
NOTE: Target variable shouldn't be present in the \code{data}}

\item{predict_function}{predict function, it will be extracted from \code{x}
if it's an explainer}

\item{label}{name of the model. By default it's extracted from the 'class'
attribute of the model.}
}
\value{
An object of the class 'aspect_importance'. Contains dataframe that
  describes aspects' importance.
}
\description{
Calculates aspect_importance for single aspects (every aspect contains only
one feature).
}
\examples{
library("DALEX")

model_titanic_glm <- glm(survived == "yes" ~ class + gender + age +
                         sibsp + parch + fare + embarked,
                         data = titanic_imputed,
                         family = "binomial")

aspect_importance_single(model_titanic_glm, data = titanic_imputed[,-9],
                         new_observation = titanic_imputed[1,-9])

}
