% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DAMisc_functions.R
\name{glmChange}
\alias{glmChange}
\title{Maximal First Differences for Generalized Linear Models}
\usage{
glmChange(
  obj,
  data,
  V = NULL,
  typical.dat = NULL,
  change.dat = NULL,
  diffchange = c("range", "sd", "unit"),
  outcome = c("diff", "maxdiff"),
  n = 1,
  catdiff = c("biggest", "all"),
  sim = FALSE,
  R = 1000,
  qtiles = c(0.025, 0.975),
  adjust = c("none", "shift", "trim")
)
}
\arguments{
\item{obj}{A model object of class \code{glm}.}

\item{data}{Data frame used to fit \code{object}.}

\item{V}{An optional variance-covariance matrix for the coefficients, if 
\code{NULL}, will be obtained through a call to \code{vcov}.}

\item{typical.dat}{Data frame with a single row containing values at which
to hold variables constant when calculating first differences.  These values
will be passed to \code{predict}, so factors must take on a single value,
but have all possible levels as their levels attribute.}

\item{change.dat}{A named list of values over which the variables of interest 
will be changed.  If \code{NULL} or partially specified, unspecified variables
will use \code{diffchange}.  If a categorical variable is specified in here, this 
overrides the \code{catdiff} argument and only the specified contrast will be 
generated.}

\item{diffchange}{A string indicating the difference in predictor values to
calculate the discrete change.  \code{range} gives the difference between
the minimum and maximum, \code{sd} gives plus and minus one-half standard
deviation change around the median and \code{unit} gives a plus and minus
one-half unit change around the median.}

\item{outcome}{For quantitative variables, should the difference over the range of chosen values be calculated 
(the default) or should the maximum probability difference over the range be 
calculated.  These will be the same for single-term quantitative variables, 
but could be different for multi-term variables, like splines and polynomials.}

\item{n}{number of units of \code{diffchange} to move.  Only active for \code{unit}
or \code{sd}.}

\item{catdiff}{String identifying how differences in factor variables
is handled.  Options are \code{"all"} in which case all pairwise differences are
returned, or \code{"biggest"} in which case the biggest difference is returned.}

\item{sim}{Logical indicating whether simulated confidence bounds on the
difference should be calculated and presented.}

\item{R}{Number of simulations to perform if \code{sim} is \code{TRUE}}

\item{qtiles}{Quantiles to calculate if \code{sim=TRUE}.}

\item{adjust}{String identifying how range should be changed if it goes out of
the bounds of the observed data.  Trimming will simply truncate the size of 
the change to make it fit in bounds.  Shifting will shift the interval so 
both ends are in bounds. If the shifted interval is wider than the range of
the data, the change will be truncated to the range of the data.}
}
\value{
A list with the following elements: \item{diffs}{A matrix of
calculated first differences} \item{minmax}{A matrix of values that were
used to calculate the predicted changes}
}
\description{
For objects of class \code{glm}, it calculates the change in predicted
responses, for maximal discrete changes in all covariates holding all other
variables constant at typical values.
}
\details{
The function calculates the changes in predicted responses for maximal
discrete changes in the covariates, for objects of class \code{glm}.  This
function works with polynomials specified with the \code{poly} function.  It
also works with multiplicative interactions of the covariates by virtue of
the fact that it holds all other variables at typical values.  By default,
typical values are the median for quantitative variables and the mode for
factors. The way the function works with factors is a bit different.  The
function identifies the two most different levels of the factor and
calculates the change in predictions for a change from the level with the
smallest prediction to the level with the largest prediction.
}
\examples{

data(france)
left.mod <- glm(voteleft ~ male + age + retnat + 
	poly(lrself, 2), data=france, family=binomial)
typical.france <- data.frame(
	retnat = factor(1, levels=1:3, labels=levels(france$retnat)), 
	age = 35, stringsAsFactors=TRUE
	)
glmChange(left.mod, data=france, typical.dat=typical.france)

}
\author{
Dave Armstrong
}
