% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SM_SARMA_UserFunctions.R
\name{sarma.est}
\alias{sarma.est}
\alias{qarma.est}
\title{Estimation of an SARMA-process}
\usage{
sarma.est(Y, method = "HR", model_order = list(ar = c(1, 1), ma = c(1, 1)))

qarma.est(Y, model_order = list(ar = c(1, 1), ma = c(1, 1)))
}
\arguments{
\item{Y}{A numeric matrix that contains the demeaned observations of the
random field or functional time-series.}

\item{method}{Method used for estimation of the parameters. One of \code{
"HR", "sep", "RSS"}, default value is \code{"HR"}}

\item{model_order}{A list containing the orders of the SARMA model in the
form \code{model_order = list(ar = c(p1, p2), ma = c(q1, q2))}. Default
value is a \eqn{SARMA((1, 1), (1, 1))} model.}
}
\value{
The function returns an object of class \code{"sarma"} including
 \tabular{ll}{
  \code{Y} \tab The matrix of observations, inherited from input.\cr
  \code{innov} The estimated innovations.\cr
  \code{model} \tab The estimated model consisting of the coefficient 
  matrices \code{ar} and \code{ma} and standard deviation of innovations
  \code{sigma}.\cr
  \code{stnry} \tab An logical variable indicating whether the estimated
  model is stationary.\cr
}
}
\description{
Parametric Estimation of an \eqn{SARMA(p, q)}-process on a 
 lattice.
}
\section{Details}{

The MA- and AR-parameters of a top-left quadrant ARMA process are estimated
by the specified method. The lag-orders of the \eqn{SARMA(p, q)} are given by
 \eqn{p = (p_1, p_2), q = (q_1, q_2)}{p = (p1, p2), q = (q1, q2)}, where
 \eqn{p_1, q_1}{p1, q1} are the lags over the rows and \eqn{p_2, q_2}{p2, q2}
 are the lags over the columns. The estimation process is based on the model
 \deqn{\phi(B_{1}B_{2})X_{i,j} = \theta(B_{1}B_{2})u_{i,j}}{\phi(B1 B2)
 X[i,j] = \theta(B1 B2)u[i,j]}.
}

\examples{
# See vignette("DCSmooth") for examples and explanation

## simulation of SARMA process
ma <- matrix(c(1, 0.2, 0.4, 0.1), nrow = 2, ncol = 2)
ar <- matrix(c(1, 0.5, -0.1, 0.1), nrow = 2, ncol = 2)
sigma <- 0.5
sarma_model <- list(ar = ar, ma = ma, sigma = sigma)
sarma_simulated <- sarma.sim(100, 100, model = sarma_model)
sarma_simulated$model

## estimation of SARMA process
sarma.est(sarma_simulated$Y)$model
sarma.est(sarma_simulated$Y, 
           model_order = list(ar = c(1, 1), ma = c(1, 1)))$model

}
\seealso{
\code{\link{sarma.sim}}, \code{\link{sfarima.est}}
}
