\name{dea.ccr.oo.env}
\alias{dea.ccr.oo.env}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{ CCR output oriented model in envelopment form }
\description{
  Fits an output oriented DEA model in envelopment form with constant returns to scale. This model corresponds to eqs. 3.60-3.63 in Cooper \emph{et al}., 2007 (see References).
}
\usage{
dea.ccr.oo.env(X, Y)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{X}{ inputs. Bidimensional data frame or object that can be coerced to a data frame. Each row corresponds to a DMU, each column to an input. }
  \item{Y}{ outputs. Bidimensional data frame or object that can be coerced to a data frame. Each row corresponds to a DMU, each column to an output. }
}
\details{
  Missing values are not allowed.
}
\value{
  a list with components:
  \item{eff}{a vector containing the technical efficiency of the DMUs.}
  \item{lambda}{a bidimensional data frame containing the  \eqn{\lambda} coefficients. Each row corresponds to a DMU. The columns correspond to the \eqn{\lambda}s.}
  \item{slack}{a vector containing the sum of slacks for each DMU.}
}
\references{

	Cooper, W. W., Seiford, L. M. and Tone, K.  (2007):
	\emph{Data envelopment analysis: a comprehensive text with models, applications, references and DEA-solver software.} Second edition. Springer. New York.
}


\seealso{ \code{\link{dea.ccr.oo.mul}} }
%\examples{
%##---- Should be DIRECTLY executable !! ----
%##-- ==>  Define data, use random,
%##--	or do  help(data=index)  for the standard data sets.
%}

% Add one or more standard keywords, see file 'KEYWORDS' in the
% R documentation directory.
\keyword{ optimize }
