% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DEEVD.R
\name{plot.Gumbel}
\alias{plot.Gumbel}
\title{Density Plot by Gumbel kernel}
\usage{
\method{plot}{Gumbel}(x, ...)
}
\arguments{
\item{x}{an object of class "Gumbel"}

\item{\dots}{Not presently used in this implementation}
}
\value{
nothing
}
\description{
Plot density by using Gumbel Kernel.
}
\examples{
y <- rexp(100,1)
h <- 0.79 * IQR(y) * length(y) ^ (-1/5)
den <- Gumbel(y,200,h)
plot(den, type = "s", ylab = "Density Function", lty = 1, xlab = "Time")
}
\references{
Khan, J. A.; Akbar, A. Density Estimation by Gumbel Kernel. 2020. \emph{Working paper,  Department of Statistics, Bahauddin Zakariya University, Multan, Pakistan.}
}
\seealso{
For Weibull kernel see \code{\link{plot.Weibull}}. To calculate Gumbel estimated values see \code{\link{Gumbel}} and for
MSE by using Gumbel Kernel \code{\link{msegumbel}}.
}
\author{
Javaria Ahmad Khan, Atif Akbar.
}
