% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/blockdyn-methods.R
\name{read.DeponsBlockdyn}
\alias{read.DeponsBlockdyn}
\title{Reading simulated population count for blocks}
\usage{
read.DeponsBlockdyn(
  fname,
  title = "NA",
  landscape = "NA",
  simtime = "NA",
  startday = "NA"
)
}
\arguments{
\item{fname}{Name of the file (character) that contains movement data
generated by DEPONS. The name includes the path to the directory if this is
not the current working directory.}

\item{title}{Optional character string giving name of simulation}

\item{landscape}{The landscape used in the simulation}

\item{simtime}{Optional text string with date of simulation (format:
yyyy-mm-dd). If not provided this is obtained from name of input file}

\item{startday}{The start of the period that the  simulation represents, i.e.
the real-world equivalent of 'tick 1' (POSIXlt)}
}
\value{
\code{DeponsBlockdyn} object
}
\description{
Function for reading DEPONS simulation output with number of
animals per block for each time step.
}
\examples{
\dontrun{
# File loaded from default location
the.file <- "/Applications/DEPONS 2.1/DEPONS/PorpoisePerBlock.2020.Sep.02.20_24_17.csv"
file.exists(the.file)
porpoise.blockdyn <- read.DeponsBlockdyn(fname=the.file,
  title="Test simulation with two blocks", landscape="North Sea")
porpoise.blockdyn

# Get the latest simulation
the.file <- get.latest.sim(type="blockdyn", dir="/Applications/DEPONS 2.1/DEPONS")
owd <- getwd()
setwd("/Applications/DEPONS 2.1/DEPONS")
porpoise.blockdyn <- read.DeponsBlockdyn(fname=the.file)
setwd(owd)
}
}
\seealso{
See \code{\link{DeponsBlockdyn-class}} for details on what is stored in
the output object and \code{\link{read.DeponsParam}} for reading the parameters
used in the simulation.
}
