% Generated by roxygen2 (4.0.1): do not edit by hand
\name{AseIrt}
\alias{AseIrt}
\title{Calculates the asymptotic covariance matrices for item parameters according with the IRT model.}
\usage{
AseIrt(itemParameters, distribution = "norm",
  distributionParameters = list(mean = 0, sd = 1), logistic = TRUE,
  sampleSize = 1, irtModel = "3pl", subdivisions = 5000)
}
\arguments{
\item{itemParameters}{A matrix or vector containing the item difficulties.}

\item{distribution}{A string character indicating the generic name for the assumed distribution. Defaults to 'norm' for normal distribution.}

\item{distributionParameters}{A list of extra parameters for the distribution function.}

\item{logistic}{A logical indicating whether the logistic or the normal metric should be used.}

\item{sampleSize}{A value indicating the sample size.}

\item{irtModel}{A string stating the IRT model for all items.}

\item{subdivisions}{A numeric value stating the maximum number of subdivisions for adaptive quadrature.}
}
\value{
ase A list containing the asymptotic matrices for each item
}
\description{
Calculates the asymptotic covariance matrices for item parameters according with the IRT model.
}
\examples{
# # Not run
# #
# # data(dichotomousItemParameters)
# # threePlAse <- list()
# # threePlAse[['focal']] <- AseIrt(itemParameters = dichotomousItemParameters[['focal']],
# #                                 logistic = TRUE, sampleSize = 500, irtModel = '3pl')
# # threePlAse[['reference']] <- AseIrt(itemParameters = dichotomousItemParameters[['reference']],
# #                                     logistic = TRUE, sampleSize = 500, irtModel = '3pl')
}
\author{
Victor H. Cervantes <vcervantes at icfes.gov.co> <vhcervantesb at unal.edu.co>
}
\references{
Li, Y. & Lissitz, R. (2004). Applications of the analytically derived standard errors of Item Response Theory item parameter estimates. Journal of educational measurement, 41(2), 85--117.
}

