\name{CutoffIpr}
\alias{CutoffIpr}
\title{Cut-off points for Ipr generated estimates}
\usage{
CutoffIpr(iprStatistics = NULL, quantiles, statistic = "ncdif",
  itemParameterList = NULL, irtModel = "2pl", focalAbilities = NULL,
  focalDistribution = "norm", focalDistrExtra = list(mean = 0, sd = 1),
  referenceDistribution = "norm", referenceDistrExtra = list(mean = 0, sd =
  1), groupRatio = 1, subdivisions = 5000, logistic = TRUE,
  itemParameters = NULL, itemCovariances = NULL, nReplicates = 5000)
}
\arguments{
  \item{iprStatistics}{A numeric matrix with the statistics
  obtained for the simulated IPR item parameters or a list
  containing all the elements of the output of this
  function. If not NULL they will be used for calculating
  the cut-off points.}

  \item{quantiles}{A numeric vector with the quantiles to
  be calculated.}

  \item{statistic}{A character indicating which statistic
  will the cut-off point will be obtained for. If
  iprStatistics are provided, it is up to the user to
  correctly especify this string for it will only be
  informative; otherwise, it will be used to identify the
  statistic to be calculated. Should be one of "ncdif",
  "sam", "uam" or "mh".}

  \item{itemParameterList}{A list where each element is a
  list containing "focal" and "reference" item Parameters.
  Item parameters are assumed to be on the same scale. Item
  parameters for each group should be a matrix with nrow
  equal to the number of items. Not used if iprStatistics
  are not NULL. If itemParameterList is not NULL, the
  statistic indicated with the argument "statistic" will be
  obtained for the set of itemParameterList, the
  corresponding arguments may be provided.}

  \item{irtModel}{A string stating the irtModel to be used.
  Should be one of "1pl", "2pl", "3pl", "grm" or "pcm". Not
  used if iprStatistics are not NULL.}

  \item{focalAbilities}{Only used if statistic is "ncdif".
  If NULL, NCDIF is calculated by numerical integration of
  focal distribution. If not NULL, must be a numerical
  vector containing the abilities for the individuals in
  the focal group.}

  \item{focalDistribution}{A string stating the
  distribution assumed for the focal group. Not used if
  iprStatistics are not NULL.}

  \item{focalDistrExtra}{A list stating the extra
  parameters needed by the focal distribution function. Not
  used if iprStatistics are not NULL.}

  \item{referenceDistribution}{A string stating the
  distribution assumed for the reference group. Not used if
  iprStatistics are not NULL.}

  \item{referenceDistrExtra}{A list stating the extra
  parameters needed by the reference distribution function.
  Not used if iprStatistics are not NULL.}

  \item{groupRatio}{A positive value indicating how many
  members of the reference group are expected for each
  member of the focal group. Not used if iprStatistics are
  not NULL.}

  \item{subdivisions}{A numeric value indicating the number
  of subdivisions for numerical integration. Only used if
  focalAbilities and iprStatistics are NULL.}

  \item{logistic}{A logical value stating if the IRT model
  will use the logistic or the normal metric. Defaults to
  using the logistic metric by fixing the D constant to 1.
  If FALSE the constant is set to 1.702 so that the normal
  metric is used.}

  \item{itemParameters}{A list containing "focal" and
  "reference" item parameters. Item parameters are assumed
  to be on the same scale. Item parameters for each group
  should me a matrix with nrow equal to the number of
  items. Only used if both iprStatistics and
  itemParameterList are NULL. If used an itemParameterList
  from applying the IPR procedure will be simulated and the
  "statistic" will be calculated.}

  \item{itemCovariances}{A list containing "focal" and
  "reference" lists of matrices of covariance for item
  estimates. Only used if iprStatistics and
  itemParameterList are NULL.}

  \item{nReplicates}{A numeric value indicating the number
  of replications to perform. Only used if iprStatistics
  and itemParameterList are NULL.}
}
\value{
cutoff A list containing: 'itemParameters', NULL if not
provided as argument, 'itemCovariances', NULL if not
provided as argument, 'itemParameterList', NULL unless
calculated from 'itemParameters' or provided as argument,
'iprStatistics' the matrix of 'statistics' provided as
argument or calculated from 'itemParameterList',
'statistic' for which the IPR approach is used according to
the provided argument, 'quantiles' the vector or matrix of
calculated quantiles for each item
}
\description{
Calculates a given quantile cut-off point for each item on
the IPR estimated items statistics. This function may
produce the cut-off points for the NCDIF index, Signed and
Unsigned Area Measures and the Mantel-Haenszel statistic
based on the Monte Carlo Item parameter replication
approach. The quantiles may be calculated directly on the
output from the IprNcdif, IprSam, IprUam, and IprMh
functions; the may be calculated by obtaining the
corresponding statistics for the item parameters simulated
under the IPR approach; or by obatining both the simulated
item parameters and the statistics based on the item
parameter values and their corresponging covariance
matrices for the parameter estimates. In the latter case,
the user may choose to obtain the IPR simulated item
parameters based only on the focal group's covariance
matrix as proposed by Oshima et al. (2006), or both focal
and reference groups' matrices as proposed by Cervantes
(2012).
}
\examples{
# # Not run
# #
# # data(dichotomousItemParameters)
# # threePlAse <- list()
# # threePlAse[['focal']] <- AseIrt(itemParameters = dichotomousItemParameters[['focal']],
# #                                 logistic = TRUE, sampleSize = 500, irtModel = '3pl')
# # threePlAse[['reference']] <- AseIrt(itemParameters = dichotomousItemParameters[['reference']],
# #                                     logistic = TRUE, sampleSize = 500, irtModel = '3pl')
# # threePlIprCutoff <- CutoffIpr(itemParameters = dichotomousItemParameters,
# #                                itemCovariances = threePlAse,
# #                                nReplicates = 1000, statistic = 'ncdif', irtModel = '3pl')
}
\author{
Victor H. Cervantes <vcervantes at icfes.gov.co>
<vhcervantesb at unal.edu.co>
}
\references{
Cervantes, V. H. (2012). On using the Item Parameter
Replication (IPR) approach for power calculation of the
noncompensatory differential item functioning (NCDIF) index
(pp. 206-207). Proceedings of the V European Congress of
Methodology. Santiago de Compostela, Spain: Universidade de
Santiago de Compostela.

Oshima, T., Raju, N. & Nanda, A. (2006). A new method for
assessing the statistical significance in the Differential
Functioning of Items and Tests (DFIT) framework. Journal of
educational measurement, 43(1), 1--17.

Raju, N. (1988). The area between two item characteristic
curves. Psychometricka, 53(4), 495--502.

Roussos, L., Schnipke, D. & Pashley, P. (1999). A
generalized formula for the Mantel-Haenszel Differential
Item Functioning parameter. Journal of educational and
behavioral statistics, 24(3), 293--322.
}

