% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/makeDesign.R
\name{makeDesign}
\alias{makeDesign}
\title{Create a design matrix from a character vector.}
\usage{
makeDesign(x)
}
\arguments{
\item{x}{Character vector to be used to create the design matrix.}
}
\value{
A design matrix as the same type as returned using ?model.matrix.
}
\description{
This function wraps around model.matrix to create a design matrix based on the different levels in model.matrix. Note that the order of the column names of the design matrix will be in lexicographic order according to the locale in use. For more, see ?Comparison
}
\examples{
n_oligo_samples = 38; n_neuron_samples = 120
cell_type = c(rep("oligodendrocyte", n_oligo_samples), rep("neuron", n_neuron_samples))
design_mat = makeDesign(cell_type)
}

