% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bigEmpPVals.R
\name{bigEmpPVals}
\alias{bigEmpPVals}
\title{Use speed-optimized sorting to calculate p-values observed and simulated null test statistic using a reference pool distribution.}
\usage{
bigEmpPVals(stat, stat0, increasing = TRUE)
}
\arguments{
\item{stat}{The vector of test statistics for which p-values should be returned.}

\item{stat0}{The vector or matrix of simulated null test statistics (if matrix, will be coerced to a vector).}

\item{increasing}{Logical indicating whether the test statistics because more extreme as they increase in value from 0. Negative numbers are not allowed as inputs (i.e., the test statistic must be monotonic).}
}
\value{
A vector of p-values adjusted for the null statistics calculated, to be used as an input to the qvalue function.
}
\description{
A reimplementation of qvalue::empPvals designed to work faster and require less memory in the average case. Unlike qvalue::empPvals, *requires* the use of a reference pool distribution rather than having this as an option. Another difference of this function that the original is that it handles ties for test statistics equal to 0, to handle cases where test statistics are thresholded and may be zero more commonly than expected by chance (i.e., very rarely).
}
\examples{
test_stat = rnorm(100, 1, 1)
test_stat0 = rnorm(1000, 0, 1)
emp_pvals = bigEmpPVals(test_stat, test_stat0)
}
\author{
John Storey, Andrew McKenzie
}
\references{
Please see ?qvalue::empPVals for more; from which this function was adapted.
}

