% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/matCorr.R
\name{matCorr}
\alias{matCorr}
\title{Calculate a correlation matrix.}
\usage{
matCorr(matA, corrType, use = "pairwise.complete.obs", matB = NULL,
  secondMat = FALSE)
}
\arguments{
\item{matA}{Input data matrix with numeric entries.}

\item{corrType}{The type of correlation to be performed. Either "pearson" or "spearman".}

\item{use}{The "use" method for performing the correlation calculation. See ?cor for more information. Default = "pairwise.complete.obs" (which is one of the speed-optimized versions; see ?WGCNA::cor for more).}

\item{matB}{Optional input data matrix with which the comparison with matA will be made.}

\item{secondMat}{Logical indicator of whether there is a second matrix in the comparison or not.}
}
\value{
A correlation matrix.
data(darmanis); darmanis_subset = darmanis[1:30, ]
matcor_res = matCorr(matA = darmanis_subset, corrType = "pearson")
}
\description{
This function takes one or two input matrices and calculates a correlation matrix from it using the speed-optimized correlation function from WGCNA.
}

