% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/attributes.R
\name{getAttributes}
\alias{getAttributes}
\title{Get all attributes}
\usage{
getAttributes(
  dgeObj,
  excludeList = list("dim", "dimnames", "names", "row.names", "class")
)
}
\arguments{
\item{dgeObj}{A DGEobj}

\item{excludeList}{A list of attribute names to exclude from the output (default = list("dim", "dimnames", "names", "row.names"))}
}
\value{
A named list
}
\description{
Get all user-defined attributes from a DGEobj except for any listed in the
excludeList argument.
}
\examples{
    # example DGEobj
    exObj <- readRDS(system.file("exampleObj.RDS", package = "DGEobj"))

    getAttributes(exObj)

    # Get the formula attribute from the design (if set)
    attr(exObj$design, "formula")

}
