% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tests.R
\name{testDispersion}
\alias{testDispersion}
\title{DHARMa dispersion tests}
\usage{
testDispersion(simulationOutput, alternative = c("two.sided", "greater",
  "less"), plot = T, ...)
}
\arguments{
\item{simulationOutput}{an object of class DHARMa with simulated quantile residuals, either created via \code{\link{simulateResiduals}} or by \code{\link{createDHARMa}} for simulations created outside DHARMa}

\item{alternative}{a character string specifying whether the test should test if observations are "greater", "less" or "two.sided" compared to the simulated null hypothesis. Greater corresponds to overdispersion.}

\item{plot}{whether to plot output}

\item{...}{arguments to pass on to \code{\link{testGeneric}}}
}
\description{
This function performs a simulation-based test for over/underdispersion
}
\details{
The function implements two tests, depending on whether it is applied on a simulation with refit = F, or refit = T. 

If refit = F, the function tests the sd of the data against the sd of the simulated data. 

If refit = T, the function compares the approximate deviance (via squared pearson residuals) with the same quantity from the models refitted with simulated data. Applying this is much slower than the previous alternative, but simulations show that it is slightly more powerful as well. 

However, given the computational cost, I would suggest that most users will be satisfied with the standard dispersion test.
}
\examples{
# creating test data

testData = createData(sampleSize = 200, overdispersion = 0.5, randomEffectVariance = 0)
fittedModel <- glm(observedResponse ~ Environment1 , family = "poisson", data = testData)
simulationOutput <- simulateResiduals(fittedModel = fittedModel)

plot(simulationOutput, quantreg = FALSE)

###### Distribution tests #####

testUniformity(simulationOutput)

###### Dispersion tests #######

testDispersion(simulationOutput, alternative = "less") # underdispersion

###### Both together###########

testResiduals(simulationOutput)

###### Special tests ##########

# testing zero inflation
testZeroInflation(simulationOutput)

# testing generic summaries
countOnes <- function(x) sum(x == 1)  # testing for number of 1s
testGeneric(simulationOutput, summary = countOnes) # 1-inflation
testGeneric(simulationOutput, summary = countOnes, alternative = "less") # 1-deficit

means <- function(x) mean(x) # testing if mean prediction fits
testGeneric(simulationOutput, summary = means) 

spread <- function(x) sd(x) # testing if mean sd fits
testGeneric(simulationOutput, summary = spread) 

###### Refited ##############

# if model is refitted, a different test will be called

simulationOutput <- simulateResiduals(fittedModel = fittedModel, refit = TRUE, seed = 12)
testDispersion(simulationOutput)

###### Test per group ##############

simulationOutput = recalculateResiduals(simulationOutput, group = testData$group)
testDispersion(simulationOutput)


}
\seealso{
\code{\link{testResiduals}}, \code{\link{testUniformity}},  \code{\link{testOutliers}}, \code{\link{testZeroInflation}}, \code{\link{testGeneric}}, \code{\link{testTemporalAutocorrelation}}, \code{\link{testSpatialAutocorrelation}}
}
\author{
Florian Hartig
}
