% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_config_env.R
\name{get_config_env}
\alias{get_config_env}
\title{get_config_env helper function}
\usage{
get_config_env(system_name, logfile_dir, headless)
}
\arguments{
\item{system_name}{The name of the system (This is also the prefix used
to get the environment variables with 'SYSTEM_KEY', e.g. 'I2B2_DBNAME')}

\item{logfile_dir}{(Optional, String, default: "tempdir()")
The absolute path to folder where the logfile will be stored.}

\item{headless}{A boolean (default: FALSE). Indicating, if the function is
run only in the console (headless = TRUE) or on a GUI frontend
(headless = FALSE).}
}
\value{
If successful it returns the config, null otherwise.
}
\description{
Internal function to read settings for a certain system
  from the environment
}
\examples{
\donttest{
get_config_env(
  system_name = "i2b2",
  logfile_dir = tempdir(),
  headless = FALSE
)}

}
