% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Turing.R
\name{Turing}
\alias{Turing}
\title{Turing Test}
\usage{
Turing(OM, Data, wait = TRUE)
}
\arguments{
\item{OM}{An object of class \code{OM}}

\item{Data}{An object of class \code{Data}}

\item{wait}{Logical. Wait for key press before next plot?}
}
\description{
Plots the available data in the \code{Data} object together with 5 samples of
historical data from the Operating Model (OM) in a random order. The test is
used to determine if the data generated by the OM is similiar to the fishery
data in the \code{Data} object. In a well specified OM the user should not be able
to visually identify which of the 6 plots is the real fishery data and which
are generated by the OM.'
}
\details{
In its current form the Turing function does not interpolate missing data in the
Data object. Therefore if there are years with missing data, say in the catch
time-series, it will be obvious which are the real data and which have been
generated by the model. Future versions of the function may include methods to
impute missing data for plotting purposes.

The question to ask when examining the plots produced by \code{Turing}: do the plots
of the 6 data samples look like they are all samples from the same underlying distribution?
}
\note{
See relevant section of the \href{https://dlmtool.github.io/DLMtool/userguide/evaluating-om.html}{DLMtool User Guide} for more information.

The Turing function was suggested by Andre Punt in his review of one of our
recent projects. It is named after the Turing test, developed by Alan Turing in
1950, which is designed to see if a human can detect the difference between
human and machine generated information.
}
\examples{
\dontrun{
Turing(DLMtool::testOM, DLMtool::SimulatedData, wait=FALSE)
}

}
