% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coef.DMR.R
\name{coef.DMR}
\alias{coef.DMR}
\title{coef.DMR}
\usage{
\method{coef}{DMR}(object, df = NULL, ...)
}
\arguments{
\item{object}{Fitted DMR object.}

\item{df}{Number of parameters in the model for which coefficients are required. Default is the entire path of models.}

\item{...}{Further arguments passed to or from other methods.}
}
\value{
Vector or matrix of coefficients.
}
\description{
Extracts coefficients from a DMR object.
}
\details{
Similar to other coef methods, this function extracts coefficients from a fitted DMR object.
}
\examples{
data(miete)
y <- miete[,1]
X <- miete[,-1]
m <- DMR(X, y)
coef(m, df = 12)
}

