% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/ki.R
\name{ki}
\alias{ki}
\title{Computes Kinship Indices (KIs) for pairs of profiles}
\usage{
ki(x1, x2, hyp.1, hyp.2 = "UN", freqs = get.freqs(x1),
  markers = intersect(get.markers(x1), get.markers(x2)), theta = 0,
  ret.per.marker = FALSE)
}
\arguments{
\item{x1}{An integer matrix with \eqn{N} profiles.}

\item{x2}{An integer matrix with \eqn{N} profiles.}

\item{hyp.1}{A character vector giving the hypothesis in the numerator of the \eqn{KI}. Should be one of \link{ibdprobs}, e.g. "FS" (full sibling) or "PO" (parent/offspring) or "UN" (unrelated).}

\item{hyp.2}{A character vector giving the hypothesis in the denominator of the \eqn{KI}. Should be one of \link{ibdprobs}, e.g. "FS" (full sibling) or "PO" (parent/offspring) or "UN" (unrelated). Defaults to "UN".}

\item{freqs}{A list specifying the allelic frequencies. Should contain a vector of allelic frequencies for each marker, named after that marker.}

\item{markers}{Character vector stating the markers to use in the KI computation. Defaults to the intersection of the markers of \code{x1} and \code{x2}.}

\item{theta}{Numeric value specifying the amount of background relatedness.}

\item{ret.per.marker}{Logical. If TRUE, return a matrix of KIs, where the columns correspond to markers.}
}
\description{
Computes Kinship Indices (KIs) for pairs of profiles
}
\examples{
data(freqsNLngm)
fr <- freqsNLngm
sibs1 <- sample.profiles(1e3,fr) # sample profiles
sibs2 <- sample.relatives(sibs1,1,type="FS",freqs=fr) #sample 1 sib for each profile
#compute ki for all pairs
ki(sibs1,sibs2,hyp.1="FS",hyp.2="UN")
}
\seealso{
\link{ibs.pairs}
}

