\name{optim.relatedness}
\alias{optim.relatedness}
\title{Estimate theta and the fraction of comparisons between close relatives}
\description{
  Estimates the fraction of comparisons between pairs of close relatives
  while fitting the theta parameter minimising the object function. The
  function makes use of the R-package 'Rsolnp' which is an
  implementation of an solver for non-linear minimisation problems with
  parameter constraints.
}
\usage{
optim.relatedness(obs,theta0=0,theta1=0.03,theta.tol=10^(-7),theta.step=NULL,max.bisect=15,
                              probs,var.list=NULL,init.alpha=10^c(-4,-6,-8,-10),init.keep=FALSE,
                              objFunction=c("T2","T1","C3","C2","C1"),collapse=FALSE,trace=FALSE,
                              solnp.ctrl=list(tol=10^(-9),rho=10,delta=min(init.alpha)*0.01,trace=FALSE))
}
\arguments{
  \item{obs}{The matrix or vector of observed matches/partial-matches as
    returned by the dbCompare()-function}
  \item{theta0}{The left value of the interval in which a bisection-like
    search is performed for theta}
  \item{theta1}{Right value of interval (see theta0)}
  \item{theta.tol}{A stopping criterion for the search. If the search
    narrows within theta.tol the function terminates}
  \item{theta.step}{Default is NULL. If not a grid search will be
    performed on seq(from = theta0, to = theta1, by = theta.step)}
  \item{max.bisect}{The maximum number of bisectional iterations perform
    prior to termination}
  \item{probs}{List of vectors with allele probabilities for each locus}
  \item{var.list}{A named list of components for computing variances,
    see dbVariance. The names of the elements are the associated
    theta-values, and each component is a list of (V1,V2,V3) - see
    dbVariance with n=1}
  \item{init.alpha}{Initial values for alpha, where the order is
    (First-cousins, Avuncular, Parent-child, Full-siblings). The value
    for Unrelated is computed as 1-sum(init.alpha)}
  \item{init.keep}{Whether the initial values should be used in
    successive steps for the current optimum should be used.}
  \item{objFunction}{Which of the five different object functions should
    be used to compare observed and expected}
  \item{collapse}{Not yet implemented}
  \item{trace}{Should iteration steps and other process indicators be printed}
  \item{solnp.ctrl}{See solnp for details}
}
\details{
  Computes the proportion of comparisons between close relatives in a
  database matching exercise for each theta value under investigation.
}
\references{
  T Tvedebrink, PS Eriksen, J Curran, HS Mogensen, N Morling. 'Analysis
  of matches and partial-matches in Danish DNA reference profile
  database'. Forensic Science International: Genetics, 2011.
}
\value{
  Returns a list of three components: value, solution and var.list. The
  first element, value, is a dataframe with the value of the objection
  function for each of the theta values investigated. Solution is the
  estimated alpha-vector where the objection function was
  minimised. Finally, var.list is a names list of components for
  computing variances. May be reused in later computations for increased
  speed in some iterations.
}

\author{James Curran and Torben Tvedebrink}

\examples{
  \dontrun{
  ## Simulate some allele frequencies:
  freqs <-  replicate(10, { g = rgamma(n=10,scale=4,shape=3); g/sum(g)}, simplify=FALSE)
  ## Load the sample database:
  data(dbExample)
  obs <- dbCompare(dbExample,trace=FALSE)$m
  C3 <- optim.relatedness(obs,theta0=0.0,theta1=0.03,probs=freqs,objFunction="C3",max.bisect=30,trace=TRUE)
  }
}

