% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/drdid_panel.R
\name{drdid_panel}
\alias{drdid_panel}
\title{Locally efficient doubly robust DiD estimator for the ATT, with panel data}
\usage{
drdid_panel(
  y1,
  y0,
  D,
  covariates,
  i.weights = NULL,
  boot = FALSE,
  boot.type = "weighted",
  nboot = NULL,
  inffunc = FALSE
)
}
\arguments{
\item{y1}{An \eqn{n} x \eqn{1} vector of outcomes from the post-treatment period.}

\item{y0}{An \eqn{n} x \eqn{1} vector of outcomes from the pre-treatment period.}

\item{D}{An \eqn{n} x \eqn{1} vector of Group indicators (=1 if observation is treated in the post-treatment, =0 otherwise).}

\item{covariates}{An \eqn{n} x \eqn{k} matrix of covariates to be used in the propensity score and regression estimation.
If covariates = NULL, this leads to an unconditional DID estimator.}

\item{i.weights}{An \eqn{n} x \eqn{1} vector of weights to be used. If NULL, then every observation has the same weights.}

\item{boot}{Logical argument to whether bootstrap should be used for inference. Default is FALSE.}

\item{boot.type}{Type of bootstrap to be performed (not relevant if \code{boot = FALSE}). Options are "weighted" and "multiplier".
If \code{boot = TRUE}, default is "weighted".}

\item{nboot}{Number of bootstrap repetitions (not relevant if \code{boot = FALSE}). Default is 999.}

\item{inffunc}{Logical argument to whether influence function should be returned. Default is FALSE.}
}
\value{
A list containing the following components:
\item{ATT}{The DR DID point estimate.}
\item{se}{ The DR DID standard error.}
\item{uci}{Estimate of the upper bound of a 95\% CI for the ATT.}
\item{lci}{Estimate of the lower bound of a 95\% CI for the ATT.}
\item{boots}{All Bootstrap draws of the ATT, in case bootstrap was used to conduct inference. Default is NULL.}
 \item{att.inf.func}{Estimate of the influence function. Default is NULL.}
 \item{call.param}{The matched call.}
 \item{argu}{Some arguments used (explicitly or not) in the call (panel = TRUE, estMethod = "trad", boot, boot.type, nboot, type="dr")}
}
\description{
\code{drdid_panel} is used to compute the locally efficient doubly robust estimators for the ATT
 in difference-in-differences (DiD) setups with panel data.
}
\details{
The \code{drdid_panel} function implements the locally efficient doubly robust difference-in-differences (DID)
estimator for the average treatment effect on the treated (ATT) defined in equation (3.1)
in Sant'Anna and Zhao (2020). This estimator makes use of a logistic propensity score model for the probability
of being in the treated group, and of a linear regression model for the outcome evolution among the comparison units.


The propensity score parameters are estimated using maximum
likelihood, and the outcome regression coefficients are estimated using ordinary least squares.
}
\examples{
# Form the Lalonde sample with CPS comparison group (data in wide format)
eval_lalonde_cps <- subset(nsw, nsw$treated == 0 | nsw$sample == 2)
# Select some covariates
covX = as.matrix(cbind(eval_lalonde_cps$age, eval_lalonde_cps$educ,
                       eval_lalonde_cps$black, eval_lalonde_cps$married,
                       eval_lalonde_cps$nodegree, eval_lalonde_cps$hisp,
                       eval_lalonde_cps$re74))

# Implement traditional DR locally efficient DID with panel data
drdid_panel(y1 = eval_lalonde_cps$re78, y0 = eval_lalonde_cps$re75,
             D = eval_lalonde_cps$experimental,
             covariates = covX)

}
\references{
{

\cite{Sant'Anna, Pedro H. C. and Zhao, Jun. (2020),
"Doubly Robust Difference-in-Differences Estimators." Journal of Econometrics, Forthcoming,
\url{https://arxiv.org/abs/1812.01723}}
}
}
