% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/twfe_did_rc.R
\name{twfe_did_rc}
\alias{twfe_did_rc}
\title{Two-way fixed effects DiD estimator, with repeated cross-section data}
\usage{
twfe_did_rc(
  y,
  post,
  D,
  covariates = NULL,
  i.weights = NULL,
  boot = FALSE,
  boot.type = "weighted",
  nboot = NULL,
  inffunc = FALSE
)
}
\arguments{
\item{y}{An \eqn{n} x \eqn{1} vector of outcomes from the both pre and post-treatment periods.}

\item{post}{An \eqn{n} x \eqn{1} vector of Post-Treatment dummies (post = 1 if observation belongs to post-treatment period,
and post = 0 if observation belongs to pre-treatment period.)}

\item{D}{An \eqn{n} x \eqn{1} vector of Group indicators (=1 if observation is treated in the post-treatment period, =0 otherwise).}

\item{covariates}{An \eqn{n} x \eqn{k} matrix of covariates to be used in the regression estimation.}

\item{i.weights}{An \eqn{n} x \eqn{1} vector of weights to be used. If NULL, then every observation has the same weights.}

\item{boot}{Logical argument to whether bootstrap should be used for inference. Default is FALSE.}

\item{boot.type}{Type of bootstrap to be performed (not relevant if \code{boot = FALSE}). Options are "weighted" and "multiplier".
If \code{boot = TRUE}, default is "weighted".}

\item{nboot}{Number of bootstrap repetitions (not relevant if \code{boot = FALSE}). Default is 999.}

\item{inffunc}{Logical argument to whether influence function should be returned. Default is FALSE.}
}
\value{
A list containing the following components:
 \item{ATT}{The TWFE DID point estimate}
 \item{se}{The TWFE DID standard error}
 \item{uci}{Estimate of the upper bound of a 95\% CI for the TWFE parameter.}
 \item{lci}{Estimate of the lower bound of a 95\% CI for the TWFE parameter.}
 \item{boots}{All Bootstrap draws of the ATT, in case bootstrap was used to conduct inference. Default is NULL}
 \item{att.inf.func}{Estimate of the influence function. Default is NULL}
}
\description{
\code{twfe_did_rc} is used to compute linear two-way fixed effects estimators for the ATT
 in difference-in-differences (DiD) setups with stationary repeated cross-sectional data. As illustrated
 by Sant'Anna and Zhao (2020),this estimator generally do not recover the ATT. We encourage empiricists
 to adopt alternative specifications.
}
\examples{
# use the simulated data provided in the package
covX = as.matrix(sim_rc[,5:8])
# Implement TWFE DID estimator (you probably should consider something else....)
twfe_did_rc(y = sim_rc$y, post = sim_rc$post, D = sim_rc$d,
           covariates= covX)

}
