% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reg_did_panel.R
\name{reg_did_panel}
\alias{reg_did_panel}
\title{Outcome regression DiD estimator for the ATT, with panel data}
\usage{
reg_did_panel(
  y1,
  y0,
  D,
  covariates,
  i.weights = NULL,
  boot = FALSE,
  boot.type = "weighted",
  nboot = NULL,
  inffunc = FALSE
)
}
\arguments{
\item{y1}{An \eqn{n} x \eqn{1} vector of outcomes from the post-treatment period.}

\item{y0}{An \eqn{n} x \eqn{1} vector of outcomes from the pre-treatment period.}

\item{D}{An \eqn{n} x \eqn{1} vector of Group indicators (=1 if observation is treated in the post-treatment, =0 otherwise).}

\item{covariates}{An \eqn{n} x \eqn{k} matrix of covariates to be used in the regression estimation.
If covariates = NULL, this leads to an unconditional DID estimator.}

\item{i.weights}{An \eqn{n} x \eqn{1} vector of weights to be used. If NULL, then every observation has the same weights.}

\item{boot}{Logical argument to whether bootstrap should be used for inference. Default is FALSE.}

\item{boot.type}{Type of bootstrap to be performed (not relevant if \code{boot = FALSE}). Options are "weighted" and "multiplier".
If \code{boot = TRUE}, default is "weighted".}

\item{nboot}{Number of bootstrap repetitions (not relevant if \code{boot = FALSE}). Default is 999.}

\item{inffunc}{Logical argument to whether influence function should be returned. Default is FALSE.}
}
\value{
A list containing the following components:
 \item{ATT}{The Reg DID point estimate}
 \item{se}{The Reg DID standard error}
 \item{uci}{Estimate of the upper bound of a 95\% CI for the ATT}
 \item{lci}{Estimate of the lower bound of a 95\% CI for the ATT}
 \item{boots}{All Bootstrap draws of the ATT, in case bootstrap was used to conduct inference. Default is NULL}
 \item{att.inf.func}{Estimate of the influence function. Default is NULL}
 \item{call.param}{The matched call.}
 \item{argu}{Some arguments used (explicitly or not) in the call (panel = TRUE, boot, boot.type, nboot, type="or")}
}
\description{
\code{reg_did_panel} computes the outcome regressions estimators for the average treatment effect on the
treated in difference-in-differences (DiD) setups with panel data.
}
\details{
The \code{reg_did_panel} function implements
outcome regression difference-in-differences (DID) estimator for the average treatment effect
on the treated (ATT) defined in equation (2.2) of Sant'Anna and Zhao (2020) when panel data are available.
The estimator follows the same spirit of the nonparametric estimators proposed by Heckman, Ichimura and Todd (1997),
though here the the outcome regression models are assumed to be linear in covariates (parametric),

The nuisance parameters (outcome regression coefficients) are estimated via ordinary least squares.
}
\examples{
# Form the Lalonde sample with CPS comparison group
eval_lalonde_cps <- subset(nsw, nsw$treated == 0 | nsw$sample == 2)
# Select some covariates
covX = as.matrix(cbind(eval_lalonde_cps$age, eval_lalonde_cps$educ,
                       eval_lalonde_cps$black, eval_lalonde_cps$married,
                       eval_lalonde_cps$nodegree, eval_lalonde_cps$hisp,
                       eval_lalonde_cps$re74))
# Implement OR DID with panel data
reg_did_panel(y1 = eval_lalonde_cps$re78, y0 = eval_lalonde_cps$re75,
               D = eval_lalonde_cps$experimental,
               covariates = covX)

}
\references{
\cite{Heckman, James J., Ichimura, Hidehiko, and Todd, Petra E. (1997),"Matching as an Econometric Evaluation Estimator: Evidence from Evaluating a Job Training Programme",
Review of Economic Studies, vol. 64(4), p. 605–654, \doi{10.2307/2971733}.
}


\cite{Sant'Anna, Pedro H. C. and Zhao, Jun. (2020),
"Doubly Robust Difference-in-Differences Estimators." Journal of Econometrics, Vol. 219 (1), pp. 101-122,
\doi{10.1016/j.jeconom.2020.06.003}}
}
