% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DSConnection.R
\name{dsListResources}
\alias{dsListResources}
\title{List remote resources}
\usage{
dsListResources(conn)
}
\arguments{
\item{conn}{An object that inherits from \code{\link{DSConnection-class}}.}
}
\description{
List remote resources from the data repository. Returns the unquoted names of remote resources
accessible through this connection.

\Sexpr[results=rd,stage=render]{DSI:::methods_as_rd("dsListResources")}
}
\examples{
\dontrun{
con <- dbConnect(DSOpal::Opal(), "server1",
  "username", "password", "https://opal.example.org")
dsListResources(con)
dsDisconnect(con)
}
}
\seealso{
Other DSConnection generics: 
\code{\link{DSConnection-class}},
\code{\link{dsAggregate}()},
\code{\link{dsAssignExpr}()},
\code{\link{dsAssignResource}()},
\code{\link{dsAssignTable}()},
\code{\link{dsDisconnect}()},
\code{\link{dsGetInfo}()},
\code{\link{dsHasResource}()},
\code{\link{dsHasTable}()},
\code{\link{dsIsAsync}()},
\code{\link{dsListMethods}()},
\code{\link{dsListPackages}()},
\code{\link{dsListSymbols}()},
\code{\link{dsListTables}()},
\code{\link{dsListWorkspaces}()},
\code{\link{dsRmSymbol}()},
\code{\link{dsRmWorkspace}()},
\code{\link{dsSaveWorkspace}()}
}
\concept{DSConnection generics}
