% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tempGP.R
\name{predict.tempGP}
\alias{predict.tempGP}
\title{predict from temporal Gaussian process}
\usage{
\method{predict}{tempGP}(object, testX, testT = NULL, trainT = NULL, ...)
}
\arguments{
\item{object}{An object of class tempGP.}

\item{testX}{A matrix with each column corresponding to one input variable.}

\item{testT}{A vector of time indices of the test points. When \code{NULL}, only function \code{f(x)} is used for prediction. Default is \code{NULL}.}

\item{trainT}{Optional argument to override the existing trainT indices of the \code{tempGP} object.}

\item{...}{additional arguments for future development}
}
\value{
A vector of predictions at the testpoints in \code{testX}.
}
\description{
predict function for tempGP objects. This function computes the prediction \code{f(x)} or \code{f(x) + g(t)} depending on the temporal distance between training and test points and whether the time indices for the test points are provided.
}
\examples{
   data = DSWE::data1
   trainindex = 1:50 #using the first 50 data points to train the model
   traindata = data[trainindex,]
   xCol = 2 #input variable columns
   yCol = 7 #response column
   trainX = as.matrix(traindata[,xCol])
   trainY = as.numeric(traindata[,yCol])
   tempGPObject = tempGP(trainX, trainY)
   testdata = DSWE::data1[101:110,] # defining test data 
   testX = as.matrix(testdata[,xCol, drop = FALSE])
   predF = predict(tempGPObject, testX)

}
