% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dose.survfit.R
\name{dose.survfit}
\alias{dose.survfit}
\title{Calculate a dose-survival curve from a dose titration study, adding a
confidence band}
\usage{
dose.survfit(de, method = "rothman", avoid.degeneracy = TRUE, conf.level = 0.8)
}
\arguments{
\item{de}{A dose titration experiment like the \code{data} slot of class
\code{\link[=DE-class]{DE}}}

\item{method}{The method to be used by \code{\link[km.ci]{km.ci}} when
calculating CI}

\item{avoid.degeneracy}{When TRUE, this parameter directs the function to
introduce artificial events into the dose titration experiment, to avoid
degeneracies at the lower and upper ends of the dose-survival curve.}

\item{conf.level}{Confidence level for KM confidence band.}
}
\value{
An object of class \code{survfit}.
}
\description{
The 'dose-survival curve' is nothing other than an empirical cumulative
distribution for MTDi in the sampled population. The term 'survival' is
suggested in part by our application of the Kaplan-Meier estimator to
interval-censored toxicity information.
}
\details{
TODO: Describe details of degeneracy avoidance, once these have stabilized.
}
\examples{
CV <- 0.7; mean_mtd <- 1.0
shape <- CV^-2; scale <- mean_mtd/shape
trial <- new("DE", doses=0.25 * 1.4^(0:6),
             MTDi=rgamma(24, shape=shape, scale=scale),
             units="mg")
trial <- titration(trial, periods=10)
sf <- dose.survfit(trial@data)
summary(sf)

}
\seealso{
\code{\link{dose.survival}}, \code{\link[km.ci]{km.ci}}
}
\author{
David C. Norris
}
\keyword{survival}
