% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Swrappers.R
\name{subset.DTSg}
\alias{subset.DTSg}
\alias{subset}
\title{Subset Time Series}
\usage{
\method{subset}{DTSg}(
  x,
  i,
  cols = self$cols(),
  funby = NULL,
  ignoreDST = FALSE,
  na.status = "implicit",
  clone = getOption("DTSgClone"),
  ...
)
}
\arguments{
\item{x}{A \code{\link{DTSg}} object (S3 method only).}

\item{i}{An integerish vector indexing rows (positive numbers pick and
negative numbers omit rows) or a filter expression accepted by the \code{i}
argument of \code{\link[data.table]{data.table}}. Filter expressions can
contain the special symbol \code{\link[data.table:special-symbols]{.N}}.}

\item{cols}{A character vector specifying the columns to select. The
\emph{.dateTime} column is always selected and cannot be part of it.}

\item{funby}{One of the temporal aggregation level functions described in
\code{\link{TALFs}} or a user defined temporal aggregation level function.
Can be used to, for instance, select the last two observations of a certain
temporal level. See examples and \code{\link{aggregate}} for further
information.}

\item{ignoreDST}{A logical specifying if day saving time is ignored during
formation of the temporal level. See \code{\link{aggregate}} for further
information.}

\item{na.status}{A character string. Either \code{"explicit"}, which makes
missing timestamps according to the recognised periodicity explicit, or
\code{"implicit"}, which removes timestamps with missing values on all value
columns. Please note that filtering rows and having or making missing
timestamps explicit equals to setting the values of all other timestamps to
missing. Its default value is therefore \code{"implicit"}. To simply subset
a complete range of a \code{\link{DTSg}} object while leaving
\code{na.status} untouched, \code{\link{alter}} is probably the better
choice.}

\item{clone}{A logical specifying if the object is modified in place or if a
clone (copy) is made beforehand.}

\item{\dots}{Not used (S3 method only).}
}
\value{
Returns a \code{\link{DTSg}} object.
}
\description{
Filter rows and/or select columns of a \code{\link{DTSg}} object.
}
\examples{
# new DTSg object
x <- DTSg$new(values = flow)

# filter for the last six rows
## R6 method
x$subset(i = (.N - 5):.N)

## S3 method
subset(x = x, i = (.N - 5):.N)

# filter for the first two observations per year
## R6 method
x$subset(i = 1:2, funby = function(x, ...) {data.table::year(x)})

## S3 method
subset(x = x, i = 1:2, funby = function(x, ...) {data.table::year(x)})

}
\seealso{
\code{\link{DTSg}}, \code{\link[data.table]{data.table}},
 \code{\link[data.table:special-symbols]{.N}}, \code{\link{cols}},
 \code{\link{TALFs}}, \code{\link{alter}}
}
