% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_bar.r
\name{plot_bar}
\alias{plot_bar}
\alias{BarDiscrete}
\title{Create bar charts for discrete features}
\usage{
plot_bar(data, na.rm = TRUE, maxcat = 50, order_bar = TRUE,
  title = NULL)
}
\arguments{
\item{data}{input data to be plotted, in either \link{data.frame} or \link{data.table} format.}

\item{na.rm}{logical, indicating if missing values should be removed for each feature. The default is \code{TRUE}.}

\item{maxcat}{maximum categories allowed for each feature. The default is 50. More information in 'Details' section.}

\item{order_bar}{logical, indicating if bars should be ordered.}

\item{title}{plot title}
}
\description{
This function creates frequency bar charts for each discrete feature.
}
\details{
If a discrete feature contains more categories than \code{maxcat} specifies, it will not be passed to the plotting function.
}
\examples{
# load diamonds dataset from ggplot2
data("diamonds", package = "ggplot2")

# plot bar charts for diamonds dataset
plot_bar(diamonds)
plot_bar(diamonds, maxcat = 5)
}
\keyword{plot_bar}
