% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/use.R
\name{use_processing_script}
\alias{use_processing_script}
\title{Add a processing script to a data package.}
\usage{
use_processing_script(file = NULL, title = NULL, author = NULL)
}
\arguments{
\item{file}{\code{character} path to an existing file or name of a new R or Rmd file to create.}

\item{title}{\code{character} title of the processing script for the yaml header. Used only if file is being created.}

\item{author}{\code{character} author name for the yaml header. Used only if the file is being created.}
}
\value{
invisibly returns TRUE for success. Stops on failure.
}
\description{
The Rmd or R file or directory specified by \code{file} will be moved into
the data-raw directory. It will also be added to the yml configuration file.
}
\examples{
if(rmarkdown::pandoc_available()){
myfile <- tempfile()
file <- system.file("extdata", "tests", "extra.rmd",
                     package = "DataPackageR")
datapackage_skeleton(
  name = "datatest",
  path = tempdir(),
  code_files = file,
  force = TRUE,
  r_object_names = "data")
use_processing_script(file = "newScript.Rmd",
    title = "Processing a new dataset",
    author = "Y.N. Here.")
}
}
