% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ListTables.R
\name{getTableNames}
\alias{getTableNames}
\title{List all tables in a database schema.}
\usage{
getTableNames(connection, databaseSchema)
}
\arguments{
\item{connection}{The connection to the database server.}

\item{databaseSchema}{The name of the database schema. See details for platform-specific details.}
}
\value{
A character vector of table names. To ensure consistency across platforms, these table names are in
upper case.
}
\description{
This function returns a list of all tables in a database schema.
}
\details{
The \code{databaseSchema} argument is interpreted differently according to the different platforms:
SQL Server and PDW: The databaseSchema schema should specify both the database and the schema, e.g.
'my_database.dbo'. PostgreSQL and Redshift: The databaseSchema should specify the schema. Oracle:
The databaseSchema should specify the Oracle 'user'. MySql and Impala: The databaseSchema should
specify the database.
}
