% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DBI.R
\docType{methods}
\name{dbSendStatement,DatabaseConnectorConnection,character-method}
\alias{dbSendStatement,DatabaseConnectorConnection,character-method}
\title{Execute a data manipulation statement on a given database connection}
\usage{
\S4method{dbSendStatement}{DatabaseConnectorConnection,character}(conn,
  statement, ...)
}
\arguments{
\item{conn}{A \linkS4class{DBIConnection} object, as returned by
\code{\link[=dbConnect]{dbConnect()}}.}

\item{statement}{a character string containing SQL.}

\item{...}{Other parameters passed on to methods.}
}
\value{
\code{dbSendStatement()} returns
an S4 object that inherits from \linkS4class{DBIResult}.
The result set can be used with \code{\link[=dbGetRowsAffected]{dbGetRowsAffected()}} to
determine the number of rows affected by the query.
Once you have finished using a result, make sure to clear it
with \code{\link[=dbClearResult]{dbClearResult()}}.
An error is raised when issuing a statement over a closed
or invalid connection,
if the syntax of the statement is invalid,
or if the statement is not a non-\code{NA} string.
}
\description{
The \code{dbSendStatement()} method only submits and synchronously executes the
SQL data manipulation statement (e.g., \code{UPDATE}, \code{DELETE},
\code{INSERT INTO}, \code{DROP TABLE}, ...) to the database engine.  To query
the number of affected rows, call \code{\link[=dbGetRowsAffected]{dbGetRowsAffected()}} on the
returned result object.  You must also call \code{\link[=dbClearResult]{dbClearResult()}} after
that. For interactive use, you should almost always prefer
\code{\link[=dbExecute]{dbExecute()}}.

\Sexpr[results=rd,stage=render]{DBI:::methods_as_rd("dbSendStatement")}
}
\details{
\code{\link[=dbSendStatement]{dbSendStatement()}} comes with a default implementation that simply
forwards to \code{\link[=dbSendQuery]{dbSendQuery()}}, to support backends that only
implement the latter.
}
\seealso{
For queries: \code{\link[=dbSendQuery]{dbSendQuery()}} and \code{\link[=dbGetQuery]{dbGetQuery()}}.

Other DBIConnection generics: \code{\link{DBIConnection-class}},
  \code{\link{dbAppendTable}}, \code{\link{dbCreateTable}},
  \code{\link{dbDataType}}, \code{\link{dbDisconnect}},
  \code{\link{dbExecute}}, \code{\link{dbExistsTable}},
  \code{\link{dbGetException}}, \code{\link{dbGetInfo}},
  \code{\link{dbGetQuery}}, \code{\link{dbIsReadOnly}},
  \code{\link{dbIsValid}}, \code{\link{dbListFields}},
  \code{\link{dbListObjects}}, \code{\link{dbListResults}},
  \code{\link{dbListTables}}, \code{\link{dbReadTable}},
  \code{\link{dbRemoveTable}}, \code{\link{dbSendQuery}},
  \code{\link{dbWriteTable}}
}
