/*
 * Decompiled with CFR 0.152.
 */
package org.ohdsi.databaseConnector;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class Compression {
    public static void createZipFile(String fileName, String folder, String zipFileName, int compressionLevel) {
        Compression.createZipFile(new String[]{fileName}, folder, zipFileName, compressionLevel);
    }

    public static void createZipFile(String[] fileNames, String folder, String zipFileName, int compressionLevel) {
        try {
            folder = Compression.normalizeName(folder);
            FileOutputStream out = new FileOutputStream(zipFileName);
            ZipOutputStream zipOut = new ZipOutputStream(out);
            String skip = new File(zipFileName).getCanonicalPath().toLowerCase();
            String[] stringArray = fileNames;
            int n = fileNames.length;
            int n2 = 0;
            while (n2 < n) {
                String fileName = stringArray[n2];
                fileName = Compression.normalizeName(fileName);
                Compression.addFile(fileName, folder, zipOut, skip);
                ++n2;
            }
            zipOut.close();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static String normalizeName(String name) {
        return name.replaceAll("\\\\", "/");
    }

    private static void addFile(String fileName, String rootFolder, ZipOutputStream zipOut, String skip) {
        try {
            File file = new File(fileName);
            if (file.getCanonicalPath().toLowerCase().equals(skip)) {
                return;
            }
            String name = fileName.replace(String.valueOf(rootFolder) + "/", "");
            if (file.isDirectory()) {
                if (!fileName.equals(rootFolder)) {
                    zipOut.putNextEntry(new ZipEntry(String.valueOf(name) + "/"));
                    zipOut.closeEntry();
                }
                File[] fileArray = file.listFiles();
                int n = fileArray.length;
                int n2 = 0;
                while (n2 < n) {
                    File subFile = fileArray[n2];
                    String subFileName = subFile.getAbsolutePath();
                    subFileName = Compression.normalizeName(subFileName);
                    Compression.addFile(subFileName, rootFolder, zipOut, skip);
                    ++n2;
                }
            } else if (file.isFile()) {
                zipOut.putNextEntry(new ZipEntry(name));
                Compression.copyStream(new FileInputStream(file), zipOut);
                zipOut.closeEntry();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static void copyStream(InputStream in, OutputStream out) {
        int bufferSize = 1024;
        byte[] buffer = new byte[bufferSize];
        try {
            int bytes;
            while ((bytes = in.read(buffer)) != -1) {
                if (bytes == 0) {
                    bytes = in.read();
                    if (bytes >= 0) {
                        out.write(bytes);
                        out.flush();
                        continue;
                    }
                    break;
                }
                out.write(buffer, 0, bytes);
                out.flush();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

