% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DBI.R
\name{dbQuoteString,DatabaseConnectorConnection,character-method}
\alias{dbQuoteString,DatabaseConnectorConnection,character-method}
\title{Quote literal strings}
\usage{
\S4method{dbQuoteString}{DatabaseConnectorConnection,character}(conn, x, ...)
}
\arguments{
\item{conn}{A \linkS4class{DBIConnection} object, as returned by
\code{\link[DBI:dbConnect]{dbConnect()}}.}

\item{x}{A character vector to quote as string.}

\item{...}{Other arguments passed on to methods.}
}
\value{
\code{dbQuoteString()} returns an object that can be coerced to \link{character},
of the same length as the input.
For an empty character vector this function returns a length-0 object.

When passing the returned object again to \code{dbQuoteString()}
as \code{x}
argument, it is returned unchanged.
Passing objects of class \link[DBI]{SQL} should also return them unchanged.
(For backends it may be most convenient to return \link[DBI]{SQL} objects
to achieve this behavior, but this is not required.)
}
\description{
Call this method to generate a string that is suitable for
use in a query as a string literal, to make sure that you
generate valid SQL and protect against SQL injection attacks.

\Sexpr[results=rd,stage=render]{DBI:::methods_as_rd("dbQuoteString")}
}
\seealso{
Other DBIResult generics: 
\code{\link[DBI]{DBIResult-class}},
\code{\link[DBI]{dbBind}()},
\code{\link[DBI]{dbClearResult}()},
\code{\link[DBI]{dbColumnInfo}()},
\code{\link[DBI]{dbFetch}()},
\code{\link[DBI]{dbGetInfo}()},
\code{\link[DBI]{dbGetRowCount}()},
\code{\link[DBI]{dbGetRowsAffected}()},
\code{\link[DBI]{dbGetStatement}()},
\code{\link[DBI]{dbHasCompleted}()},
\code{\link[DBI]{dbIsReadOnly}()},
\code{\link[DBI]{dbIsValid}()},
\code{\link[DBI]{dbQuoteIdentifier}()},
\code{\link[DBI]{dbQuoteLiteral}()},
\code{\link[DBI]{dbUnquoteIdentifier}()}
}
