/*
 * Decompiled with CFR 0.152.
 */
package net.starschema.clouddb.jdbc;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.sql.SQLException;
import java.sql.SQLXML;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stax.StAXSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import net.starschema.clouddb.jdbc.BQSQLException;
import net.starschema.clouddb.jdbc.Logger;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

class BQSQLXML
implements SQLXML {
    Document document = null;
    Boolean Readable = true;
    Logger logger = Logger.getLogger(this.getClass());

    public BQSQLXML(String xmlString) throws SQLException {
        this.logger.debug("making BQSQLXML with the input: " + xmlString);
        try {
            DocumentBuilderFactory dbfac = DocumentBuilderFactory.newInstance();
            DocumentBuilder docBuilder = dbfac.newDocumentBuilder();
            this.document = docBuilder.parse(new InputSource(new StringReader(xmlString)));
        }
        catch (SAXException e) {
            throw new BQSQLException(e);
        }
        catch (IOException e) {
            throw new BQSQLException(e);
        }
        catch (ParserConfigurationException e) {
            throw new BQSQLException(e);
        }
    }

    @Override
    public void free() throws SQLException {
        this.document = null;
        this.Readable = false;
    }

    @Override
    public InputStream getBinaryStream() throws SQLException {
        if (!this.Readable.booleanValue()) {
            throw new BQSQLException("This SQLXML is not readable any more");
        }
        this.Readable = false;
        if (this.document == null) {
            throw new BQSQLException("This SQLXML is freed");
        }
        ByteArrayInputStream inptstrm = new ByteArrayInputStream(this.getS().getBytes());
        return inptstrm;
    }

    @Override
    public Reader getCharacterStream() throws SQLException {
        if (!this.Readable.booleanValue()) {
            throw new BQSQLException("This SQLXML is not readable any more");
        }
        this.Readable = false;
        if (this.document == null) {
            throw new BQSQLException("This SQLXML is freed");
        }
        StringReader rdr = new StringReader(this.getS());
        return rdr;
    }

    private String getS() throws SQLException {
        if (this.document == null) {
            throw new BQSQLException("This SQLXML is freed");
        }
        TransformerFactory transfac = TransformerFactory.newInstance();
        Transformer trans = null;
        try {
            trans = transfac.newTransformer();
        }
        catch (TransformerConfigurationException e) {
            throw new BQSQLException(e);
        }
        try {
            trans.setOutputProperty("omit-xml-declaration", "yes");
            trans.setOutputProperty("indent", "yes");
        }
        catch (IllegalArgumentException e) {
            throw new BQSQLException(e);
        }
        StringWriter sw = new StringWriter();
        StreamResult result = new StreamResult(sw);
        DOMSource source = new DOMSource(this.document);
        try {
            trans.transform(source, result);
        }
        catch (TransformerException e) {
            throw new BQSQLException(e);
        }
        String xmlString = sw.toString();
        return xmlString;
    }

    @Override
    public <T extends Source> T getSource(Class<T> sourceClass) throws SQLException {
        if (!this.Readable.booleanValue()) {
            throw new BQSQLException("This SQLXML is not readable any more");
        }
        this.Readable = false;
        if (this.document == null) {
            throw new BQSQLException("This SQLXML is freed");
        }
        if (sourceClass == null) {
            throw new BQSQLException("No default implementation");
        }
        if (sourceClass == DOMSource.class) {
            DOMSource src = new DOMSource(this.document);
            return (T)((Source)sourceClass.cast(src));
        }
        if (sourceClass == SAXSource.class) {
            SAXSource src = new SAXSource(new InputSource(new StringReader(this.getS())));
            return (T)((Source)sourceClass.cast(src));
        }
        if (sourceClass == StAXSource.class) {
            StAXSource src;
            XMLEventReader eventReaderXML;
            XMLInputFactory inputFactory = XMLInputFactory.newInstance();
            try {
                eventReaderXML = inputFactory.createXMLEventReader("Instance_01", this.getCharacterStream());
            }
            catch (XMLStreamException e1) {
                throw new BQSQLException(e1);
            }
            inputFactory.setProperty("javax.xml.stream.isSupportingExternalEntities", Boolean.TRUE);
            inputFactory.setProperty("javax.xml.stream.isNamespaceAware", Boolean.TRUE);
            inputFactory.setProperty("javax.xml.stream.isReplacingEntityReferences", Boolean.TRUE);
            try {
                src = new StAXSource(eventReaderXML);
            }
            catch (XMLStreamException e) {
                throw new BQSQLException(e);
            }
            return (T)((Source)sourceClass.cast(src));
        }
        if (sourceClass == StreamSource.class) {
            StreamSource src = new StreamSource(this.getBinaryStream());
            return (T)((Source)sourceClass.cast(src));
        }
        throw new BQSQLException("No implementation for this class");
    }

    @Override
    public String getString() throws SQLException {
        if (!this.Readable.booleanValue()) {
            throw new BQSQLException("This SQLXML is not readable any more");
        }
        this.Readable = false;
        return this.getS();
    }

    @Override
    public OutputStream setBinaryStream() throws SQLException {
        throw new BQSQLException("Not implemented.setBinaryStream()");
    }

    @Override
    public Writer setCharacterStream() throws SQLException {
        throw new BQSQLException("Not implemented.setCharacterStream");
    }

    @Override
    public <T extends Result> T setResult(Class<T> resultClass) throws SQLException {
        throw new BQSQLException("Not implemented.setResult(Class<T>)");
    }

    @Override
    public void setString(String xmlString) throws SQLException {
        throw new BQSQLException("Not implemented.setString(String)");
    }
}

