\name{sESOM4BMUs}
\alias{sESOM4BMUs}
\title{
Intern function: Simplified Emergent Self-Organizing Map
}
\description{
Intern function for the simplified ESOM (sESOM) algorithm for fixed
BestMatchingUnits.
}
\usage{
sESOM4BMUs(BMUs,Data, esom, toroid, CurrentRadius,

ComputeInR=FALSE,Parallel=TRUE)
}
\arguments{
\item{BMUs}{[1:Lines,1:Columns], BestMAtchingUnits generated by
ProjectedPoints2Grid()}
\item{Data}{[1:n,1:d] array of data: n cases in rows, d variables in columns}
\item{esom}{[1:Lines,1:Columns,1:weights] array of NeuronWeights, see
ListAsEsomNeurons()}
\item{toroid}{TRUE/FALSE - topology of points}
\item{CurrentRadius}{number betweeen 1 to x}
\item{ ComputeInR}{=T: Rcode, =F Cpp Code}{number betweeen 1 to x}
\item{Parallel}{Optional, =TRUE: Parallel C++ implementation, =FALSE C++ implementation}
}
\details{
Algorithm is described in [Thrun, 2018, p. 48, Listing 5.1].
}
\note{Usually not for seperated usage!}
\value{
\item{esom}{numeric array [1:Lines,1:Columns,1:d], d is the dimension of the
weights, the same as in the ESOM algorithm. modified esomneuros regarding a
predefined neighborhood defined by a radius}
}
\author{
Michael Thrun
}
\seealso{
\code{\link{GeneratePswarmVisualization}}
}
\references{
[Thrun, 2018]  Thrun, M. C.: Projection Based Clustering through
Self-Organization and Swarm Intelligence, doctoral dissertation 2017, Springer,
Heidelberg, ISBN: 978-3-658-20539-3, \doi{10.1007/978-3-658-20540-9}, 2018. 
}

\keyword{GeneratePswarmVisualization}
\keyword{ESOM}
