% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modify_design.R
\name{modify_design}
\alias{modify_design}
\alias{insert_step}
\alias{delete_step}
\alias{replace_step}
\title{Modify a design after the fact}
\usage{
insert_step(design, new_step, before, after)

delete_step(design, step)

replace_step(design, step, new_step)
}
\arguments{
\item{design}{A design object, usually created using the + operator, \code{\link{expand_design}}, or the design library.}

\item{new_step}{The new step; Either a function or a partial call.}

\item{before}{The step before which to add steps.}

\item{after}{The step after which to add steps.}

\item{step}{The quoted label of the step to be deleted or replaced.}
}
\value{
A new design object.
}
\description{
Insert, delete and replace steps in an (already declared) design object.
}
\details{
See \code{\link{modify_design}} for details.
}
\examples{

 my_population <- declare_population(N = 100, noise = rnorm(N), label = "my_pop")

 my_potential_outcomes <-
   declare_potential_outcomes(Y_Z_0 = noise,
                              Y_Z_1 = noise + rnorm(N, mean = 2, sd = 2))

 my_assignment <- declare_assignment(m = 50)
 my_assignment_2 <- declare_assignment(m = 25)

 design <- my_population + my_potential_outcomes + my_assignment

 design

 insert_step(design, declare_step(dplyr::mutate, income = noise^2), after = my_assignment)
 insert_step(design, declare_step(dplyr::mutate, income = noise^2), before = my_assignment)

 # If you are using a design created by a designer, for example from
 #   the DesignLibrary package, you will not have access to the step
 #   objects. Instead, you can always use the label of the step.
 
 # get the labels for the steps
 names(design)
 
 insert_step(design, declare_sampling(n = 50), after = "my_pop")


 delete_step(design, my_assignment)
 replace_step(design, my_assignment, declare_step(dplyr::mutate, words = "income"))
}
