% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/declare_assignment.R
\name{declare_assignment}
\alias{declare_assignment}
\alias{assignment_handler}
\title{Declare Data Strategy: Assignment}
\usage{
declare_assignment(..., handler = assignment_handler, label = NULL)

assignment_handler(data, ..., legacy = TRUE)
}
\arguments{
\item{...}{arguments to be captured, and later passed to the handler}

\item{handler}{a tidy-in, tidy-out function}

\item{label}{a string describing the step}

\item{data}{A data.frame.}

\item{legacy}{Use the legacy randomizr functionality. This will be disabled in future; please use legacy = FALSE.}
}
\value{
A function that takes a data.frame as an argument and returns a data.frame with assignment columns appended.
}
\description{
Declare Data Strategy: Assignment
}
\examples{

# setting up a design stub
design <- declare_model(
  classrooms = add_level(10),
  individuals = add_level(20, female = rbinom(N, 1, 0.5))
) + NULL

# Declare assignment of m units to treatment
design + declare_assignment(Z = complete_ra(N = N, m = 100), legacy = FALSE)

# Declare assignment specifying varying block probabilities
design + 
  declare_assignment(Z = block_ra(blocks = female, 
                                  block_prob = c(1/3, 2/3)), legacy = FALSE)

# Declare assignment of clusters with probability 1/4
design + declare_assignment(
  Z = cluster_ra(prob = 1/4, clusters = classrooms), legacy = FALSE)
 
# Declare factorial assignment (Approach 1): 
#   Use complete random assignment to assign Z1 
#   then block on Z1 to assign Z2. 
design + 
   declare_assignment(Z1 = complete_ra(N = N, m = 100),
                      Z2 = block_ra(blocks = Z1), legacy = FALSE)
   
# Declare factorial assignment (Approach 2): 
#   Assign to four conditions and then split into Z1 and Z2 
design +  
  declare_assignment(Z = complete_ra(N = N, conditions = 1:4),
                     Z1 = as.numeric(Z \%in\% 2:3), 
                     Z2 = as.numeric(Z \%in\% 3:4), legacy = FALSE)
   
# Declare assignment using functions outside randomizr package:
design + 
  declare_assignment(Z = rbinom(n = N, size = 1, prob = 0.35), legacy = FALSE)

}
