% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gzc.algorithm.R
\name{gzc.algorithm}
\alias{gzc.algorithm}
\title{Calculates instantaneous frequency of simplified IMF using the GZC
method}
\usage{
gzc.algorithm(xy, dt)
}
\arguments{
\item{xy}{a matrix of amplitude}

\item{dt}{a vector of depth or time values}
}
\value{
a list of $ldt (left position), $rdt (right position), $f
(frequency) and $a (amplitude)
}
\description{
Calculates instantaneous frequency of simplified IMF using the
Generalised Zero-Crossing method from Huang et al., 2009.
}
\details{
the GZC method is precise to 1/4th of a period, so the results are
provided between left and right points, i.e. either an extrema or a
zero-crossing.
}
\examples{
xyi  <- c(0.5,0,-0.5,0,0.5,0,-0.5,0,0.5,0,-0.5,0,0.5,0,-0.5,0,0.5,0,-0.5,0,
         1,1,0,-1,-1,0,1,1,0,-1,-1,0,1,1,0,-1,-1)

dti <- 1:length(xyi)

d <- simp.emd(m = xyi, dt = dti)

xy <- d$xy
dt <- d$dt

res <- gzc.algorithm(xy, dt)

opar <- par('mfrow')

par(mfrow = c(2,1))

plot(dti, xyi, pch = 19, type = "o", ylab = "xy", xlab = "dt")
points(dt, xy, pch = 19, col = "green")
points(res$ldt, res$a, pch = 19, col = "red")
points(res$rdt, res$a, pch = 19, col = "red")

plot(dt, rep(max(res$f, na.rm = TRUE), length(dt)), type = "n",
     ylab = "Frequency", xlab = "dt",
     ylim = c(0, 2 * max(res$f, na.rm = TRUE)))
points(res$ldt, res$f, pch = 19)
points(res$rdt, res$f, pch = 19)

par(mfrow = opar)

}
\references{
Huang, Norden E., Zhaohua Wu, Steven R. Long, Kenneth C. Arnold,
Xianyao Chen, and Karin Blank. 2009. ‘On Instantaneous Frequency’. Advances
in Adaptive Data Analysis 01 (02): 177–229.
https://doi.org/10.1142/S1793536909000096.
}
