/*
 * Decompiled with CFR 0.152.
 */
package org.rosuda.deducer.widgets;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.rosuda.REngine.REXP;
import org.rosuda.REngine.REXPLanguage;
import org.rosuda.REngine.REXPMismatchException;
import org.rosuda.REngine.REXPReference;
import org.rosuda.REngine.REngineException;
import org.rosuda.REngine.RList;
import org.rosuda.deducer.Deducer;
import org.rosuda.deducer.widgets.RDialog;

public class SimpleRDialog
extends RDialog
implements ActionListener {
    private String rCheckFunc;
    private String rRunFunc;
    private REXPReference checkRef;
    private REXPReference runRef;

    public SimpleRDialog() {
        this.setOkayCancel(true, true, this);
        this.setLocationRelativeTo(null);
    }

    public SimpleRDialog(String string, String string2) {
        this.rCheckFunc = string;
        this.rRunFunc = string2;
        this.checkRef = null;
        this.runRef = null;
        this.setOkayCancel(true, true, this);
        this.setLocationRelativeTo(null);
    }

    public SimpleRDialog(REXPReference rEXPReference, REXPReference rEXPReference2) {
        this.rCheckFunc = null;
        this.rRunFunc = null;
        this.checkRef = rEXPReference;
        this.runRef = rEXPReference2;
        this.setOkayCancel(true, true, this);
        this.setLocationRelativeTo(null);
    }

    public void setCheckFunction(String string) {
        this.rCheckFunc = string;
        this.checkRef = null;
    }

    public void setCheckFunction(REXPReference rEXPReference) {
        this.checkRef = rEXPReference;
        this.rCheckFunc = null;
    }

    public Object getCheckFunction() {
        if (this.rCheckFunc != null) {
            return this.rCheckFunc;
        }
        return this.checkRef;
    }

    public void setRunFunction(String string) {
        this.rRunFunc = string;
        this.runRef = null;
    }

    public void setRunFunction(REXPReference rEXPReference) {
        this.rRunFunc = null;
        this.runRef = rEXPReference;
    }

    public Object getRunFunction() {
        if (this.rRunFunc != null) {
            return this.rRunFunc;
        }
        return this.runRef;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        final String string = actionEvent.getActionCommand();
        new Thread(new Runnable(){

            public void run() {
                SimpleRDialog.this.runCmd(string);
            }
        }).start();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void runCmd(String string) {
        if (string.equals("Run") || string.equals("OK")) {
            Object object;
            String string2 = this.getWidgetStatesAsString();
            REXP rEXP = null;
            if (this.rCheckFunc != null) {
                rEXP = Deducer.timedEval(this.rCheckFunc + "(" + string2 + ")");
            } else if (this.checkRef != null) {
                object = Deducer.timedEval(string2);
                try {
                    rEXP = this.checkRef.getEngine().eval(new REXPLanguage(new RList(new REXP[]{this.checkRef, object})), null, false);
                }
                catch (REngineException rEngineException) {
                    rEngineException.printStackTrace();
                }
                catch (REXPMismatchException rEXPMismatchException) {
                    rEXPMismatchException.printStackTrace();
                }
            }
            object = "";
            try {
                if (rEXP != null) {
                    object = rEXP.asString();
                }
            }
            catch (REXPMismatchException rEXPMismatchException) {
                JOptionPane.showMessageDialog(this, "Dialog error. Check function must return a string. Return \"\" if the check passes.");
            }
            if (((String)object).length() < 1) {
                try {
                    System.out.println(string2);
                    if (this.rRunFunc != null) {
                        Deducer.timedEval(this.rRunFunc + "(" + string2 + ")");
                    } else if (this.runRef != null) {
                        REXP rEXP2 = Deducer.timedEval(string2);
                        this.runRef.getEngine().eval(new REXPLanguage(new RList(new REXP[]{this.runRef, rEXP2})), null, false);
                    }
                }
                catch (REngineException rEngineException) {
                    rEngineException.printStackTrace();
                }
                catch (REXPMismatchException rEXPMismatchException) {
                    rEXPMismatchException.printStackTrace();
                }
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        SimpleRDialog.this.setVisible(false);
                    }
                });
                this.completed();
                return;
            }
            JOptionPane.showMessageDialog(this, object);
            return;
        }
        if (string.equals("Cancel")) {
            this.clearWorkingModels();
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    SimpleRDialog.this.setVisible(false);
                }
            });
            return;
        } else {
            if (!string.equals("Reset")) return;
            this.reset();
        }
    }
}

