/*
 * Decompiled with CFR 0.152.
 */
package org.rosuda.deducer.widgets.param;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import org.rosuda.deducer.toolkit.IconButton;
import org.rosuda.deducer.widgets.param.RFunctionList;

class HeaderPanel
extends JPanel
implements ActionListener {
    private JSeparator sep1;
    private JButton options;
    private JSeparator jSeparator1;
    private JCheckBox check;
    private RFunctionList model;
    private String fName;
    private boolean active;
    private boolean required;

    public HeaderPanel(RFunctionList rFunctionList, String string, boolean bl, boolean bl2) {
        this.model = rFunctionList;
        this.fName = string;
        this.active = bl;
        this.required = bl2;
        this.initGUI();
    }

    private void initGUI() {
        try {
            Color color = new Color(50, 50, 50);
            this.setPreferredSize(new Dimension(400, 30));
            this.setMinimumSize(new Dimension(250, 30));
            this.setMaximumSize(new Dimension(400, 30));
            BoxLayout boxLayout = new BoxLayout(this, 0);
            this.setLayout(boxLayout);
            this.sep1 = new JSeparator();
            this.add(this.sep1);
            this.sep1.setPreferredSize(new Dimension(50, 2));
            this.sep1.setMaximumSize(new Dimension(50, 2));
            this.sep1.setAlignmentY(0.5f);
            this.sep1.setForeground(color);
            this.add(Box.createRigidArea(new Dimension(5, 0)));
            this.check = new JCheckBox();
            this.add(this.check);
            this.check.setText(this.fName);
            this.check.setSelected(this.active);
            if (this.required) {
                this.check.setSelected(true);
                this.check.setEnabled(false);
            }
            this.check.setAlignmentY(0.5f);
            this.check.setMinimumSize(new Dimension(100, this.check.getMinimumSize().height));
            Dimension dimension = this.check.getPreferredSize();
            this.check.setPreferredSize(new Dimension(Math.max(dimension.width, 100), dimension.height));
            dimension = this.check.getMaximumSize();
            this.check.setMaximumSize(new Dimension(Math.max(dimension.width, 100), dimension.height));
            this.add(Box.createRigidArea(new Dimension(5, 0)));
            this.options = new IconButton("/icons/advanced_21.png", "options", this, "options");
            this.add(this.options);
            this.options.setPreferredSize(new Dimension(24, 24));
            this.options.setAlignmentY(0.5f);
            this.add(Box.createHorizontalGlue());
            this.jSeparator1 = new JSeparator();
            this.add(this.jSeparator1);
            this.jSeparator1.setPreferredSize(new Dimension(50, 2));
            this.jSeparator1.setMaximumSize(new Dimension(50, 2));
            this.jSeparator1.setAlignmentY(0.5f);
            this.jSeparator1.setForeground(color);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public JCheckBox getCheckBox() {
        return this.check;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        OptionDialog optionDialog = new OptionDialog(null);
        optionDialog.setModal(true);
        optionDialog.setLocationRelativeTo(this.options);
        optionDialog.setVisible(true);
    }

    class OptionDialog
    extends JDialog
    implements ActionListener {
        private JCheckBox keep;
        private JLabel nameLabel;
        private JButton okay;
        private JButton cancel;
        private JCheckBox print;
        private JTextField name;

        public OptionDialog(JFrame jFrame) {
            super(jFrame);
            this.initGUI();
        }

        private void initGUI() {
            try {
                int n = -1;
                for (int i = 0; i < HeaderPanel.this.model.getOptions().length; ++i) {
                    if (!HeaderPanel.this.model.getOptions()[i].equals(HeaderPanel.this.fName)) continue;
                    n = i;
                }
                this.getContentPane().setLayout(null);
                this.keep = new JCheckBox();
                this.getContentPane().add(this.keep);
                this.keep.setText("Keep in workspace");
                this.keep.setBounds(12, 12, 163, 19);
                this.keep.setSelected(((HeaderPanel)HeaderPanel.this).model.keep[n].equals("true"));
                this.nameLabel = new JLabel();
                this.getContentPane().add(this.nameLabel);
                this.nameLabel.setText("Name:");
                this.nameLabel.setBounds(22, 37, 54, 15);
                this.nameLabel.setHorizontalAlignment(11);
                this.name = new JTextField();
                this.getContentPane().add(this.name);
                this.name.setBounds(82, 33, 68, 22);
                this.name.setText(((HeaderPanel)HeaderPanel.this).model.assignTo[n]);
                this.print = new JCheckBox();
                this.getContentPane().add(this.print);
                this.print.setText("Print");
                this.print.setBounds(12, 67, 163, 19);
                this.print.setSelected(((HeaderPanel)HeaderPanel.this).model.print[n].equals("true"));
                this.okay = new JButton();
                this.getContentPane().add(this.okay);
                this.okay.setText("Okay");
                this.okay.setBounds(110, 110, 78, 22);
                this.okay.addActionListener(this);
                this.cancel = new JButton();
                this.getContentPane().add(this.cancel);
                this.cancel.setText("Cancel");
                this.cancel.setBounds(33, 110, 71, 22);
                this.cancel.addActionListener(this);
                this.setSize(200, 166);
                this.setResizable(false);
                this.setTitle("Options");
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            if (string.equals("Okay")) {
                for (int i = 0; i < HeaderPanel.this.model.getOptions().length; ++i) {
                    if (!HeaderPanel.this.model.getOptions()[i].equals(HeaderPanel.this.fName)) continue;
                    ((HeaderPanel)HeaderPanel.this).model.assignTo[i] = this.name.getText();
                    ((HeaderPanel)HeaderPanel.this).model.keep[i] = this.keep.isSelected() ? "true" : "false";
                    ((HeaderPanel)HeaderPanel.this).model.print[i] = this.print.isSelected() ? "true" : "false";
                }
                this.dispose();
            } else if (string.equals("Cancel")) {
                this.dispose();
            }
        }
    }
}

