/*
 * Decompiled with CFR 0.152.
 */
package org.rosuda.deducer.menu;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import org.rosuda.JGR.RController;
import org.rosuda.JGR.layout.AnchorConstraint;
import org.rosuda.JGR.layout.AnchorLayout;
import org.rosuda.JGR.util.ErrorMsg;
import org.rosuda.REngine.REXP;
import org.rosuda.REngine.REXPLogical;
import org.rosuda.deducer.Deducer;
import org.rosuda.deducer.toolkit.DJList;
import org.rosuda.deducer.toolkit.HelpButton;
import org.rosuda.deducer.toolkit.IconButton;
import org.rosuda.deducer.toolkit.OkayCancelPanel;
import org.rosuda.deducer.toolkit.VariableSelector;

public class TransformDialog
extends JDialog
implements ActionListener {
    private VariableSelector variableSelector;
    private JList transformVariableList;
    private JButton intoButton;
    private IconButton removeButton;
    private IconButton addButton;
    private HelpButton help;
    private OkayCancelPanel okayCancelPanel;
    private JButton plotButton;
    private JComboBox typeComboBox;
    private JSpinner binSpinner;
    private JPanel transPanel;
    private JComboBox rankComboBox;
    private JLabel binLabel;
    private JLabel rankLabel;
    private String plotType;
    private static String[] types = new String[]{":::       Select Transformation       :::", "            --- Scalings ---", "Center:    x-mean(x)", "Standardize:    (x-mean(x))/sd(x)", "Robust Std.:    (x-median(x))/mad(x))", "Range:    (x+min(x))/range(x)", "Box-Cox", "Rank", "Natural log:    log(x)", "Log + 1:    log(x+1)", "Square Root:    sqrt(x)", "Absolute Value:    abs(x)", "Squared:    x^2", "Inverse:    1/x", "Reciprocal root:    -1/sqrt(x)", "Arcsine:    asin(sqrt(x))", "            --- Binnings ---", "Quantiles", "Equal Width", "            --- Custom ---", "Enter Function..."};
    private static TransformDialogModel lastModel;

    public TransformDialog(JFrame jFrame) {
        super(jFrame);
        if (lastModel == null) {
            lastModel = new TransformDialogModel();
        }
        this.initGUI();
        this.setModel(lastModel);
    }

    private void initGUI() {
        try {
            this.setTitle("Transform Variables");
            AnchorLayout anchorLayout = new AnchorLayout();
            this.getContentPane().setLayout((LayoutManager)anchorLayout);
            this.help = new HelpButton("pmwiki.php?n=Main.TransformVariables");
            this.getContentPane().add((Component)this.help, new AnchorConstraint(867, 934, 968, 21, 0, 0, 1, 1));
            this.help.setPreferredSize(new Dimension(32, 32));
            this.removeButton = new IconButton("/icons/1leftarrow_32.png", "Remove", this, "Remove");
            this.getContentPane().add((Component)this.removeButton, new AnchorConstraint(150, 425, 680, 350, 2, 0, 0, 1));
            this.removeButton.setPreferredSize(new Dimension(41, 40));
            this.addButton = new IconButton("/icons/1rightarrow_32.png", "Add", this, "Add");
            this.getContentPane().add((Component)this.addButton, new AnchorConstraint(100, 425, 525, 350, 2, 0, 0, 1));
            this.addButton.setPreferredSize(new Dimension(41, 40));
            this.intoButton = new JButton();
            this.getContentPane().add((Component)this.intoButton, new AnchorConstraint(50, 934, 295, 782, 1, 1, 0, 0));
            this.intoButton.setText("\u2192 Target");
            this.intoButton.setPreferredSize(new Dimension(96, 26));
            this.intoButton.setFont(new Font("Tahoma", 0, 10));
            this.intoButton.addActionListener(this);
            JPanel jPanel = new JPanel();
            BorderLayout borderLayout = new BorderLayout();
            jPanel.setLayout(borderLayout);
            this.transformVariableList = new RecodeDJList();
            JScrollPane jScrollPane = new JScrollPane(this.transformVariableList, 22, 31);
            jPanel.add(jScrollPane);
            this.getContentPane().add((Component)jPanel, new AnchorConstraint(25, 758, 600, 435, 1, 1, 1, 1));
            this.transformVariableList.setModel(new DefaultListModel());
            jPanel.setPreferredSize(new Dimension(184, 240));
            jPanel.setBorder(BorderFactory.createTitledBorder("Variables to Transform"));
            this.plotButton = new JButton("Plot");
            this.getContentPane().add((Component)this.plotButton, new AnchorConstraint(601, 945, 295, 525, 1, 0, 0, 1));
            this.plotButton.addActionListener(this);
            this.transPanel = new JPanel();
            this.transPanel.setBorder(BorderFactory.createTitledBorder("Transformation"));
            this.getContentPane().add((Component)this.transPanel, new AnchorConstraint(670, 765, 900, 350, 1, 1, 1, 1));
            this.transPanel.setLayout((LayoutManager)new AnchorLayout());
            this.typeComboBox = new JComboBox<String>(types);
            this.transPanel.add((Component)this.typeComboBox, new AnchorConstraint(160, 980, 460, 20, 1, 1, 1, 1));
            this.typeComboBox.setEditable(false);
            this.typeComboBox.addActionListener(this);
            this.binLabel = new JLabel("# of bins:");
            this.binLabel.setHorizontalAlignment(4);
            this.binLabel.setVerticalAlignment(0);
            this.binLabel.setPreferredSize(new Dimension(60, 25));
            this.transPanel.add((Component)this.binLabel, new AnchorConstraint(500, 500, 700, 20, 1, 1, 0, 1));
            this.binLabel.setVisible(false);
            this.binSpinner = new JSpinner(new SpinnerNumberModel(4, 2, 1000, 1));
            this.transPanel.add((Component)this.binSpinner, new AnchorConstraint(500, 900, 900, 520, 1, 0, 0, 1));
            this.binSpinner.setVisible(false);
            this.rankLabel = new JLabel("Ties:");
            this.rankLabel.setHorizontalAlignment(4);
            this.rankLabel.setVerticalAlignment(0);
            this.rankLabel.setPreferredSize(new Dimension(60, 25));
            this.transPanel.add((Component)this.rankLabel, new AnchorConstraint(500, 500, 700, 20, 1, 1, 0, 1));
            this.rankComboBox = new JComboBox<String>(new String[]{"average", "first", "random", "max", "min"});
            this.transPanel.add((Component)this.rankComboBox, new AnchorConstraint(500, 900, 900, 520, 1, 0, 0, 1));
            this.variableSelector = new VariableSelector();
            this.getContentPane().add((Component)this.variableSelector, new AnchorConstraint(25, 325, 835, 21, 1, 1, 1, 1));
            this.variableSelector.setPreferredSize(new Dimension(192, 301));
            this.variableSelector.setBorder(BorderFactory.createEtchedBorder(1));
            this.variableSelector.getJComboBox().addActionListener(this);
            this.variableSelector.setDropStringSplitter("\u2192");
            if (TransformDialog.lastModel.data != null) {
                this.variableSelector.setSelectedData(TransformDialog.lastModel.data);
            }
            this.okayCancelPanel = new OkayCancelPanel(true, true, this);
            this.add((Component)this.okayCancelPanel, new AnchorConstraint(926, 978, 980, 402, 0, 1, 1, 0));
            this.okayCancelPanel.setPreferredSize(new Dimension(307, 32));
            this.setMinimumSize(new Dimension(450, 250));
            this.setSize(640, 500);
        }
        catch (Exception exception) {
            new ErrorMsg(exception);
        }
    }

    public void setDataName(String string) {
        if (!string.equals(this.variableSelector.getSelectedData())) {
            this.variableSelector.setSelectedData(string);
        }
    }

    private void setModel(TransformDialogModel transformDialogModel) {
        try {
            Object object;
            if (transformDialogModel.variables != null && transformDialogModel.data != null) {
                this.variableSelector.reset();
                this.transformVariableList.setModel(transformDialogModel.variables);
                for (int i = 0; i < transformDialogModel.variables.getSize(); ++i) {
                    object = (String)transformDialogModel.variables.get(i);
                    boolean bl = this.variableSelector.remove(object = ((String)object).substring(0, ((String)object).indexOf("\u2192")));
                    if (bl) continue;
                    this.transformVariableList.setModel(new DefaultListModel());
                    JList jList = this.variableSelector.getJList();
                    VariableSelector variableSelector = this.variableSelector;
                    variableSelector.getClass();
                    jList.setModel(new VariableSelector.FilteringModel(variableSelector, Deducer.timedEval("names(" + this.variableSelector.getJComboBox().getSelectedItem() + ")").asStrings()));
                    break;
                }
            }
            if (transformDialogModel.variables.size() == 0) {
                this.variableSelector.reset();
                this.transformVariableList.setModel(transformDialogModel.variables);
            }
            if (((DefaultComboBoxModel)(object = (DefaultComboBoxModel)this.typeComboBox.getModel())).getIndexOf(transformDialogModel.transform) >= 0) {
                this.typeComboBox.setSelectedItem(transformDialogModel.transform);
            } else {
                this.typeComboBox.setEditable(true);
                this.typeComboBox.setSelectedItem(transformDialogModel.transform);
            }
            this.binSpinner.setValue(transformDialogModel.bins);
            this.rankComboBox.setSelectedItem(transformDialogModel.rankTies);
            this.plotType = transformDialogModel.plot;
        }
        catch (Exception exception) {
            new ErrorMsg(exception);
        }
    }

    private TransformDialogModel getModel() {
        TransformDialogModel transformDialogModel = new TransformDialogModel();
        transformDialogModel.bins = (Integer)this.binSpinner.getValue();
        transformDialogModel.data = this.variableSelector.getSelectedData();
        transformDialogModel.rankTies = (String)this.rankComboBox.getSelectedItem();
        transformDialogModel.transform = (String)this.typeComboBox.getSelectedItem();
        DefaultListModel defaultListModel = (DefaultListModel)this.transformVariableList.getModel();
        DefaultListModel defaultListModel2 = new DefaultListModel();
        for (int i = 0; i < defaultListModel.size(); ++i) {
            defaultListModel2.addElement(defaultListModel.get(i));
        }
        transformDialogModel.variables = defaultListModel2;
        if (this.plotType != null) {
            transformDialogModel.plot = this.plotType;
        }
        return transformDialogModel;
    }

    private void plot() {
        String string;
        DefaultListModel defaultListModel = (DefaultListModel)this.transformVariableList.getModel();
        Vector<String> vector = new Vector<String>();
        Vector<String> vector2 = new Vector<String>();
        for (int i = 0; i < defaultListModel.size(); ++i) {
            string = (String)defaultListModel.get(i);
            vector.add(string.split("\u2192")[0]);
            vector2.add(string.split("\u2192")[1]);
        }
        String string2 = Deducer.makeRCollection(vector, "c", true);
        string = this.variableSelector.getSelectedData();
        if (defaultListModel.size() == 0) {
            JOptionPane.showMessageDialog(this, "Please select a variable.");
            return;
        }
        for (int i = 0; i < vector.size(); ++i) {
            REXP rEXP = Deducer.timedEval("is.numeric(" + string + "$" + (String)vector.get(i) + ")");
            if (rEXP != null && rEXP.isLogical() && !((REXPLogical)rEXP).isFALSE()[0]) continue;
            JOptionPane.showMessageDialog(this, vector.get(i).toString() + " is not a numeric variable.");
            return;
        }
        Deducer.execute("dev.new(); onesample.plot(" + string + "[," + string2 + "]" + ")");
    }

    private String getSingleCall(String string, String string2, String string3, String string4, String string5) {
        String string6 = null;
        if (string3 == types[2]) {
            string6 = string2 + " <- " + string + " - mean(" + string + ", na.rm=TRUE)\n";
        } else if (string3 == types[3]) {
            string6 = string2 + " <- (" + string + " - mean(" + string + ",na.rm=TRUE)) / sd(" + string + ",na.rm=TRUE)\n";
        } else if (string3 == types[4]) {
            string6 = string2 + " <- (" + string + " - median(" + string + ",na.rm=TRUE)) / mad(" + string + ",na.rm=TRUE)\n";
        } else if (string3 == types[5]) {
            string6 = string2 + " <- (" + string + " - min(" + string + ",na.rm=TRUE)) / diff(range(" + string + ",na.rm=TRUE))\n";
        } else if (string3 == types[6]) {
            string6 = string2 + " <- bcPower(" + string + "," + string4 + ")\n";
        } else if (string3 == types[7]) {
            string6 = string2 + " <- rank(" + string + ", na.last='keep', ties='" + this.rankComboBox.getSelectedItem().toString() + "')\n";
        } else if (string3 == types[8]) {
            string6 = string2 + " <- log(" + string + ")\n";
        } else if (string3 == types[9]) {
            string6 = string2 + " <- log(" + string + " + 1)\n";
        } else if (string3 == types[10]) {
            string6 = string2 + " <- ifelse(" + string + "<0, NA, sqrt(" + string + "))\n";
        } else if (string3 == types[11]) {
            string6 = string2 + " <- abs(" + string + ")\n";
        } else if (string3 == types[12]) {
            string6 = string2 + " <- " + string + "^2\n";
        } else if (string3 == types[13]) {
            string6 = string2 + " <- 1/" + string + "\n";
        } else if (string3 == types[14]) {
            string6 = string2 + " <- -1/sqrt(" + string + ")\n";
        } else if (string3 == types[15]) {
            string6 = string2 + " <- asin(sqrt(" + string + "))\n";
        } else if (string3 == types[17]) {
            int n = (Integer)this.binSpinner.getValue();
            string6 = string2 + " <- cut2(" + string + ", g=" + n + ")\n";
        } else if (string3 == types[18]) {
            string6 = string2 + " <- cut(" + string + "," + this.binSpinner.getValue().toString() + ", include.lowest=TRUE)\n";
        } else if (this.typeComboBox.getSelectedIndex() == 20 || this.typeComboBox.getSelectedIndex() < 0) {
            string6 = string2 + " <- " + string5 + "(" + string + ")\n";
        }
        return string6;
    }

    private String getCall() {
        int n;
        Object object;
        int n2;
        Object object2;
        DefaultListModel defaultListModel = (DefaultListModel)this.transformVariableList.getModel();
        if (defaultListModel.size() == 0) {
            JOptionPane.showMessageDialog(this, "Please select a variable.");
            return null;
        }
        if (this.typeComboBox.getSelectedIndex() == 0) {
            JOptionPane.showMessageDialog(this, "Please select a Transformation.");
            return null;
        }
        Vector<String> vector = new Vector<String>();
        Vector<String> vector2 = new Vector<String>();
        for (int i = 0; i < defaultListModel.size(); ++i) {
            String string = (String)defaultListModel.get(i);
            vector.add(string.split("\u2192")[0]);
            vector2.add(string.split("\u2192")[1]);
        }
        String string = this.variableSelector.getSelectedData();
        for (int i = 0; i < vector.size(); ++i) {
            object2 = Deducer.timedEval("is.numeric(" + string + "$" + (String)vector.get(i) + ")");
            if (object2 != null && ((REXP)object2).isLogical() && !((REXPLogical)object2).isFALSE()[0]) continue;
            JOptionPane.showMessageDialog(this, vector.get(i).toString() + " is not a numeric variable.");
            return null;
        }
        String string2 = "";
        object2 = null;
        boolean bl = this.typeComboBox.getSelectedIndex() == 6;
        boolean bl2 = this.typeComboBox.getSelectedIndex() == 20 || this.typeComboBox.getSelectedIndex() < 0;
        String string3 = null;
        String string4 = Deducer.getUniqueName("trans.function");
        String string5 = null;
        String string6 = null;
        if (bl || this.typeComboBox.getSelectedIndex() == 8) {
            for (n2 = 0; n2 < vector.size(); ++n2) {
                object = Deducer.timedEval("all(" + string + "$" + (String)vector.get(n2) + ">0)");
                if (object != null && ((REXP)object).isLogical() && !((REXPLogical)object).isFALSE()[0] || (n = JOptionPane.showOptionDialog(this, vector.get(n2).toString() + " Has values <=0, which is not valid for this tranformation.\n" + "Would you like to coninue anyway?", "Warning", 0, 2, null, new String[]{"Continue", "Cancel"}, "Cancel")) == 0) continue;
                return null;
            }
        }
        if (this.typeComboBox.getSelectedIndex() == 9) {
            for (n2 = 0; n2 < vector.size(); ++n2) {
                object = Deducer.timedEval("all(" + string + "$" + (String)vector.get(n2) + ">(-1))");
                if (object != null && ((REXP)object).isLogical() && !((REXPLogical)object).isFALSE()[0] || (n = JOptionPane.showOptionDialog(this, vector.get(n2).toString() + " Has values <= -1, which is not valid for this tranformation.\n" + "Would you like to coninue anyway?", "Warning", 0, 2, null, new String[]{"Continue", "Cancel"}, "Cancel")) == 0) continue;
                return null;
            }
        }
        if (this.typeComboBox.getSelectedIndex() == 15) {
            for (n2 = 0; n2 < vector.size(); ++n2) {
                object = Deducer.timedEval("all(" + string + "$" + (String)vector.get(n2) + ">=0) && all(" + string + "$" + (String)vector.get(n2) + "<=1)");
                if (object != null && ((REXP)object).isLogical() && !((REXPLogical)object).isFALSE()[0] || (n = JOptionPane.showOptionDialog(this, vector.get(n2).toString() + " Has values outside of [0 1], which is not valid for this tranformation.\n" + "Would you like to coninue anyway?", "Warning", 0, 2, null, new String[]{"Continue", "Cancel"}, "Cancel")) == 0) continue;
                return null;
            }
        }
        if (this.typeComboBox.getSelectedIndex() == 17) {
            String string7 = Deducer.requirePackage("Hmisc");
            if (string7 == "installed") {
                string2 = string2 + "library(Hmisc)\n";
            } else if (string7 == "not-installed") {
                return null;
            }
        }
        if (bl2) {
            string3 = "function(x) " + this.typeComboBox.getSelectedItem().toString();
            REXP rEXP = Deducer.timedEval("is.function(try(" + string3 + ",silent=TRUE))");
            if (rEXP == null || !rEXP.isLogical() || ((REXPLogical)rEXP).isFALSE()[0]) {
                JOptionPane.showMessageDialog(this, string3 + " is not a valid function.");
                return null;
            }
        }
        if (vector.size() == 1) {
            string5 = string + "[['" + (String)vector.get(0) + "']]";
            string6 = string + "[['" + (String)vector2.get(0) + "']]";
            if (bl) {
                object2 = Deducer.getUniqueName("box.cox.mle");
                string2 = string2 + (String)object2 + " <- powerTransform(" + string5 + ")\n";
                string2 = string2 + "print(" + (String)object2 + ")\n";
            }
            if (bl2) {
                string2 = string2 + string4 + " <- " + string3 + "\n";
            }
            string2 = string2 + this.getSingleCall(string5, string6, (String)this.typeComboBox.getSelectedItem(), (String)object2 + "$lambda", string4);
            if (bl) {
                string2 = string2 + "rm(" + (String)object2 + ")\n";
            }
            if (bl2) {
                string2 = string2 + "rm(" + string4 + ")\n";
            }
            if (this.plotType == "Histogram") {
                string2 = string2 + "onesample.plot(d(" + string5 + ", " + string6 + "))\n";
            }
        } else {
            String string8 = Deducer.getUniqueName("variables");
            object = Deducer.getUniqueName("into.variables");
            string2 = string2 + string8 + " <- " + Deducer.makeRCollection(vector, "c", true) + "\n";
            string2 = string2 + (String)object + " <- " + Deducer.makeRCollection(vector2, "c", true) + "\n";
            if (bl) {
                object2 = Deducer.getUniqueName("box.cox.mle");
                string2 = string2 + (String)object2 + " <- powerTransform(" + string + "[," + string8 + "])\n";
                string2 = string2 + "print(" + (String)object2 + ")\n";
            }
            string5 = string + "[[" + string8 + "[i]]]";
            string6 = string + "[[" + (String)object + "[i]]]";
            if (bl2) {
                string2 = string2 + string4 + " <- " + string3 + "\n";
            }
            string2 = string2 + "for(i in 1:length(" + string8 + "))\n\t" + this.getSingleCall(string5, string6, (String)this.typeComboBox.getSelectedItem(), (String)object2 + "$lambda[i]", string4);
            if (this.plotType == "Histogram") {
                string2 = string2 + "onesample.plot(" + string + "[,c(" + string8 + ", " + (String)object + ")])\n";
            }
            string2 = string2 + "rm(list=c('" + string8 + "','" + (String)object + "'" + (bl ? ",'" + (String)object2 + "'" : "") + (bl2 ? ",'" + string4 + "'" : "") + "))\n";
        }
        return string2;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object[] objectArray;
        int n;
        String string = actionEvent.getActionCommand();
        if (string == "Cancel") {
            this.dispose();
        } else if (string == "Add") {
            JList jList = this.variableSelector.getJList();
            Object[] objectArray2 = jList.getSelectedValues();
            for (int i = 0; i < objectArray2.length; ++i) {
                if (objectArray2[i] == null) continue;
                String string2 = (String)objectArray2[i];
                ((DefaultListModel)this.transformVariableList.getModel()).addElement(string2.concat("\u2192".concat(string2 + ".tr")));
                this.variableSelector.remove(objectArray2[i]);
            }
        } else if (string == "Remove") {
            Object[] objectArray3 = this.transformVariableList.getSelectedValues();
            for (int i = 0; i < objectArray3.length; ++i) {
                if (objectArray3[i] == null) continue;
                String string3 = (String)objectArray3[i];
                ((DefaultListModel)this.transformVariableList.getModel()).removeElement(objectArray3[i]);
                this.variableSelector.add(string3.substring(0, string3.indexOf("\u2192")));
            }
        } else if (string == "\u2192 Target") {
            int n2 = this.transformVariableList.getSelectedIndex();
            if (n2 == -1) {
                return;
            }
            String string4 = (String)this.transformVariableList.getSelectedValue();
            string4 = string4.substring(0, string4.indexOf("\u2192"));
            String string5 = JOptionPane.showInputDialog(this, (Object)("Recode " + string4 + " into:"));
            if (string5 == null || string5.length() == 0) {
                return;
            }
            string5 = RController.makeValidVariableName((String)string5);
            ((DefaultListModel)this.transformVariableList.getModel()).removeElementAt(n2);
            ((DefaultListModel)this.transformVariableList.getModel()).addElement(string4 + "\u2192" + string5);
        } else if (string == "comboBoxChanged") {
            if (actionEvent.getSource() == this.variableSelector.getJComboBox()) {
                this.transformVariableList.setModel(new DefaultListModel());
            } else {
                if (this.typeComboBox.getSelectedIndex() == 7) {
                    this.rankComboBox.setVisible(true);
                    this.rankLabel.setVisible(true);
                    this.binSpinner.setVisible(false);
                    this.binLabel.setVisible(false);
                } else if (this.typeComboBox.getSelectedIndex() >= 17 && this.typeComboBox.getSelectedIndex() <= 18) {
                    this.rankComboBox.setVisible(false);
                    this.rankLabel.setVisible(false);
                    this.binSpinner.setVisible(true);
                    this.binLabel.setVisible(true);
                } else {
                    this.rankComboBox.setVisible(false);
                    this.rankLabel.setVisible(false);
                    this.binSpinner.setVisible(false);
                    this.binLabel.setVisible(false);
                }
                if (this.typeComboBox.getSelectedIndex() == 20 || this.typeComboBox.getSelectedIndex() < 0) {
                    this.typeComboBox.setEditable(true);
                } else {
                    this.typeComboBox.setEditable(false);
                }
                if (((String)this.typeComboBox.getSelectedItem()).startsWith("            ---")) {
                    this.typeComboBox.setSelectedIndex(0);
                }
            }
        } else if (string == "Run") {
            lastModel = this.getModel();
            String string6 = this.getCall();
            if (string6 != null) {
                Deducer.setRecentData(this.variableSelector.getSelectedData());
                Deducer.execute(string6);
                this.dispose();
            }
        } else if (string == "Reset") {
            this.setModel(new TransformDialogModel());
        } else if (string == "Plot" && (n = JOptionPane.showOptionDialog(this, "Select plot type:", "Plot", 0, 3, null, objectArray = new String[]{"None", "Histogram"}, this.plotType)) >= 0) {
            this.plotType = objectArray[n];
        }
    }

    static /* synthetic */ String[] access$100() {
        return types;
    }

    class TransformDialogModel {
        public DefaultListModel variables = new DefaultListModel();
        public String data = null;
        public String transform = TransformDialog.access$100()[0];
        public String rankTies = "average";
        public Integer bins = new Integer(4);
        public String plot = "None";

        TransformDialogModel() {
        }
    }

    private class RecodeDJList
    extends DJList {
        private RecodeDJList() {
        }

        public void drop(DropTargetDropEvent dropTargetDropEvent) {
            super.drop(dropTargetDropEvent);
            int n = this.getModel().getSize();
            for (int i = 0; i < n; ++i) {
                String string = (String)this.getModel().getElementAt(i);
                if (string.indexOf("\u2192") >= 0) continue;
                ((DefaultListModel)this.getModel()).removeElementAt(i);
                ((DefaultListModel)this.getModel()).add(i, string + "\u2192" + string + ".tr");
            }
        }
    }
}

