/*
 * Decompiled with CFR 0.152.
 */
package org.rosuda.deducer.widgets.param;

import org.rosuda.deducer.Deducer;
import org.rosuda.deducer.toolkit.XMLHelper;
import org.rosuda.deducer.widgets.VariableSelectorWidget;
import org.rosuda.deducer.widgets.param.Param;
import org.rosuda.deducer.widgets.param.ParamMultipleVariablesWidget;
import org.rosuda.deducer.widgets.param.ParamWidget;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ParamMultipleVariables
extends Param {
    protected String data;
    protected String[] variables = new String[0];
    protected String defaultData;
    protected String[] defaultVariables = new String[0];
    protected String format = FORMAT_DATA;
    protected String dataParamName = "data";
    public static String FORMAT_DATA = "data[,'variable']";
    public static String FORMAT_VARIABLE = "=d(variable),data=data";
    public static String FORMAT_VARIABLE_CHARACTER = "=c('variable'),data=data";

    public ParamMultipleVariables() {
        this.view = "org.rosuda.deducer.widgets.param.ParamMultipleVariablesWidget";
        this.requiresVariableSelector = true;
        this.view = "org.rosuda.deducer.widgets.param.ParamMultipleVariablesWidget";
    }

    public ParamMultipleVariables(String string) {
        this.name = string;
        this.title = string;
        this.requiresVariableSelector = true;
        this.view = "org.rosuda.deducer.widgets.param.ParamMultipleVariablesWidget";
    }

    public ParamMultipleVariables(String string, String string2, String[] stringArray) {
        this(string);
        this.data = string2;
        this.variables = stringArray;
        this.defaultData = null;
        this.defaultVariables = new String[0];
        this.requiresVariableSelector = true;
        this.view = "org.rosuda.deducer.widgets.param.ParamMultipleVariablesWidget";
    }

    public Object clone() {
        int n;
        ParamMultipleVariables paramMultipleVariables = new ParamMultipleVariables();
        paramMultipleVariables.setName(this.getName());
        paramMultipleVariables.setTitle(this.getTitle());
        paramMultipleVariables.setViewType(this.getViewType());
        paramMultipleVariables.data = this.data;
        String[] stringArray = new String[this.variables.length];
        for (n = 0; n < this.variables.length; ++n) {
            stringArray[n] = this.variables[n];
        }
        paramMultipleVariables.variables = stringArray;
        paramMultipleVariables.defaultData = this.defaultData;
        stringArray = new String[this.defaultVariables.length];
        for (n = 0; n < this.defaultVariables.length; ++n) {
            stringArray[n] = this.defaultVariables[n];
        }
        paramMultipleVariables.defaultVariables = stringArray;
        paramMultipleVariables.requiresVariableSelector = this.requiresVariableSelector;
        paramMultipleVariables.required = this.required;
        return paramMultipleVariables;
    }

    public Object getDefaultValue() {
        return this.defaultVariables;
    }

    public String[] getParamCalls() {
        String[] stringArray = new String[]{};
        if (this.getValue() != null && !this.getValue().equals(this.getDefaultValue())) {
            String string = "";
            if (this.getDefaultValue() == null || this.getValue() != null && !this.getDefaultValue().toString().equals(this.getValue().toString())) {
                if (this.getFormat().equals(FORMAT_DATA)) {
                    stringArray = new String[]{(this.name != null ? this.name + " = " : "") + this.data + "[," + Deducer.makeRCollection(this.variables, "c", true) + ", drop=FALSE]"};
                } else if (this.getFormat().equals(FORMAT_VARIABLE)) {
                    stringArray = new String[]{(this.name != null ? this.name + " = " : "") + Deducer.makeRCollection(this.variables, "d", false), this.dataParamName + " = " + this.data};
                } else if (this.getFormat().equals(FORMAT_VARIABLE_CHARACTER)) {
                    stringArray = new String[]{(this.name != null ? this.name + " = " : "") + Deducer.makeRCollection(this.variables, "c", true), this.dataParamName + " = " + this.data};
                }
            } else {
                string = "";
            }
        } else {
            stringArray = new String[]{};
        }
        return stringArray;
    }

    public Object getValue() {
        return this.variables;
    }

    public ParamWidget getView() {
        return null;
    }

    public ParamWidget getView(VariableSelectorWidget variableSelectorWidget) {
        return new ParamMultipleVariablesWidget(this, variableSelectorWidget);
    }

    public boolean requiresVariableSelector() {
        return true;
    }

    public void setDefaultValue(Object object) {
        this.defaultVariables = (String[])object;
    }

    public void setValue(Object object) {
        this.variables = (String[])object;
    }

    public void setData(String string) {
        this.data = string;
    }

    public String getData() {
        return this.data;
    }

    public void setVariables(String[] stringArray) {
        this.variables = stringArray;
    }

    public void setVariables(String string) {
        this.variables = new String[]{string};
    }

    public String[] getVariables() {
        return this.variables;
    }

    public void setDefaultData(String string) {
        this.defaultData = string;
    }

    public String getDefaultData() {
        return this.defaultData;
    }

    public void setDefaultVariable(String[] stringArray) {
        this.defaultVariables = stringArray;
    }

    public void setDefaultVariable(String string) {
        this.defaultVariables = new String[]{string};
    }

    public String[] getDefaultVariable() {
        return this.defaultVariables;
    }

    public Element toXML() {
        Element element = super.toXML();
        if (this.data != null) {
            element.setAttribute("data", this.data);
        }
        if (this.defaultData != null) {
            element.setAttribute("defaultData", this.defaultData);
        }
        if (this.getFormat() != null) {
            element.setAttribute("format", this.getFormat());
        }
        if (this.dataParamName != null) {
            element.setAttribute("dataParamName", this.dataParamName);
        }
        element.setAttribute("className", "org.rosuda.deducer.widgets.param.ParamVariable");
        XMLHelper.appendCollection((Node)element, this.variables, "variables");
        XMLHelper.appendCollection((Node)element, this.defaultVariables, "defaultVariables");
        return element;
    }

    public void setFromXML(Element element) {
        String string = element.getAttribute("className");
        if (!string.equals("org.rosuda.deducer.widgets.param.ParamLogical")) {
            System.out.println("Error ParamLogical: class mismatch: " + string);
            new Exception().printStackTrace();
        }
        super.setFromXML(element);
        this.variables = XMLHelper.getChildCollection(element, "variables");
        this.defaultVariables = XMLHelper.getChildCollection(element, "defaultVariables");
        this.data = element.hasAttribute("data") ? element.getAttribute("data") : null;
        this.defaultData = element.hasAttribute("defaultData") ? element.getAttribute("defaultData") : null;
        if (element.hasAttribute("format")) {
            this.setFormat(element.getAttribute("format"));
        } else {
            this.setFormat(null);
        }
        this.dataParamName = element.hasAttribute("dataParamName") ? element.getAttribute("dataParamName") : null;
    }

    protected void setDataParamName(String string) {
        this.dataParamName = string;
    }

    protected String getDataParamName() {
        return this.dataParamName;
    }

    public boolean hasValidEntry() {
        return this.variables != null && this.variables.length > 0 || this.defaultVariables != null && this.defaultVariables.length > 0;
    }

    public void setFormat(String string) {
        this.format = string;
    }

    public String getFormat() {
        return this.format;
    }
}

