/*
 * Decompiled with CFR 0.152.
 */
package org.rosuda.ibase.plots;

import java.awt.Frame;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import org.rosuda.ibase.NotifyMsg;
import org.rosuda.ibase.SMarker;
import org.rosuda.ibase.SVar;
import org.rosuda.ibase.toolkit.BaseCanvas;
import org.rosuda.ibase.toolkit.FrequencyTable;
import org.rosuda.ibase.toolkit.PPrimBase;
import org.rosuda.ibase.toolkit.PPrimMosaic;
import org.rosuda.ibase.toolkit.PlotPrimitive;
import org.rosuda.pograss.PoGraSS;
import org.rosuda.util.Tools;

public class MosaicCanvas
extends BaseCanvas {
    static final String M_PLUS = "+";
    static final String M_OBSERVED = "observed";
    static final String M_EXPECTED = "expected";
    static final String M_SAMEBINSIZE = "samebinsize";
    static final String M_MULTIPLEBARCHARTS = "multiplebarcharts";
    static final String M_FLUCTUATION = "fluctuation";
    static final String M_MAXLEVELUP = "maxLevelUp";
    static final String M_MAXLEVELDOWN = "maxLevelDown";
    static final String M_CENSORUP = "censorUp";
    static final String M_CENSORDOWN = "censorDown";
    static final String M_PERMUTELEFT = "permuteLeft";
    static final String M_PERMUTERIGHT = "permuteRight";
    private SVar[] v;
    private int vs;
    private Frame frame;
    private int maxLevel;
    private int w;
    private int h;
    private int hgap;
    private int vgap;
    private static final int DISPLAY_MODE_OBSERVED = 0;
    private static final int DISPLAY_MODE_EXPECTED = 1;
    private static final int DISPLAY_MODE_SAMEBINSIZE = 2;
    private static final int DISPLAY_MODE_MULTIPLEBARCHARTS = 3;
    private static final int DISPLAY_MODE_FLUCTUATION = 4;
    private int mode = 0;
    private FrequencyTable ft;
    private int[] combination;
    private int[] x1x2 = new int[2];
    private int[] y1y2 = new int[2];
    private int subX;
    private final int standardMLeft = 20;
    private List rects = new ArrayList();
    private int[] plevels;
    private int[] aGap;
    private int[] Gaps;
    private char[] Dirs;
    private double residSum;
    private int censor = 0;

    public MosaicCanvas(int n, Frame frame, SVar[] sVarArray, SMarker sMarker) {
        super(n, frame, sMarker);
        int n2;
        this.frame = frame;
        this.v = sVarArray;
        this.changingHilitingNeedsUpdateRoot = 0;
        this.maxLevel = this.v.length;
        this.vs = this.v.length;
        for (n2 = 0; n2 < this.vs; ++n2) {
            this.v[n2].addDepend(this);
            this.v[n2].categorize();
        }
        this.createMenu(frame, true, false, false, true, new String[]{"Observed", M_OBSERVED, "Expected", M_EXPECTED, "Same bin size", M_SAMEBINSIZE, "Multiple barcharts", M_MULTIPLEBARCHARTS, "Fluctuation", M_FLUCTUATION, "-", "Less variables (up)", M_MAXLEVELUP, "More variables (down)", M_MAXLEVELDOWN, "Increase censor (shift+up)", M_CENSORUP, "Decrease censor (shift+down)", M_CENSORDOWN, "Reorder variables left (left)", M_PERMUTELEFT, "Reorder variables right (right)", M_PERMUTERIGHT});
        this.setDefaultMargins(new int[]{20, 5, 20, 5});
        this.ft = new FrequencyTable(this.v);
        this.Dirs = new char[this.vs];
        for (n2 = 0; n2 < this.vs; ++n2) {
            this.Dirs[n2] = n2 % 2 == 0 ? 120 : 121;
        }
        this.dontPaint = false;
    }

    public void updateObjects() {
        if (this.dontPaint) {
            return;
        }
        this.create(this.mLeft, this.mTop, this.getWidth() - this.mRight, this.getHeight() - this.mBottom, "");
        if (this.pp == null || this.pp.length != this.rects.size()) {
            this.pp = new PlotPrimitive[this.rects.size()];
        }
        this.rects.toArray(this.pp);
        for (int i = 0; i < this.pp.length; ++i) {
            this.setColors((PPrimBase)this.pp[i]);
        }
        String string = "Mosaic Plot (";
        for (int i = 0; i < this.vs; ++i) {
            string = i < this.vs - 1 && i != this.maxLevel - 1 ? string + this.v[i].getName() + ", " : string + this.v[i].getName();
            if (i + 1 != this.maxLevel || this.maxLevel >= this.vs) continue;
            string = string + ")[";
        }
        string = this.maxLevel < this.vs ? string + "]" : string + ")";
        this.frame.setTitle(string);
        this.setUpdateRoot(0);
    }

    public String queryObject(int n) {
        String string = "";
        boolean bl = this.isExtQuery;
        if (bl) {
            if (this.pp != null && this.pp[n] != null) {
                int n2 = (int)((double)this.pp[n].cases() * this.pp[n].getMarkedProportion(this.m, -1) + 0.5);
                string = string + ((PPrimMosaic)this.pp[n]).toString() + "\ncount: " + this.pp[n].cases();
                if (this.v != null && this.v[0] != null) {
                    string = string + " (" + Tools.getDisplayableValue(100.0 * (double)this.pp[n].cases() / (double)this.v[0].size(), 2) + "% of total)";
                }
                if (n2 > 0) {
                    string = string + "\nselected: " + n2 + " (" + Tools.getDisplayableValue(100.0 * this.pp[n].getMarkedProportion(this.m, -1), 2) + "% of this cat., " + (this.v != null && this.v[0] != null ? Tools.getDisplayableValue(100.0 * (double)n2 / (double)this.v[0].size(), 2) + "% of total, " : "") + Tools.getDisplayableValue(100.0 * (double)n2 / (double)this.m.marked(), 2) + "% of total selection)";
                }
            } else {
                string = "N/A";
            }
        } else if (this.pp != null && this.pp[n] != null) {
            int n3 = (int)((double)this.pp[n].cases() * this.pp[n].getMarkedProportion(this.m, -1) + 0.5);
            string = string + ((PPrimMosaic)this.pp[n]).toString() + "\ncount: " + this.pp[n].cases() + (n3 > 0 ? "\nselected: " + n3 : "");
        } else {
            string = "N/A";
        }
        return string;
    }

    public String queryPlotSpace() {
        if (this.v == null) {
            return null;
        }
        String string = "Mosaicplot (";
        for (int i = 0; i < this.v.length - 1; ++i) {
            string = string + this.v[i].getName() + ", ";
        }
        string = string + this.v[this.v.length - 1].getName() + ")";
        return string + (this.m.marked() > 0 ? "\n" + this.m.marked() + " selected case(s)" : "");
    }

    public Object run(Object object, String string) {
        int n;
        int n2;
        int[] nArray;
        super.run(object, string);
        if (M_OBSERVED.equals(string) && this.mode != 0) {
            this.mode = 0;
            this.setUpdateRoot(0);
            this.updateObjects();
            this.repaint();
        }
        if (M_EXPECTED.equals(string) && this.mode != 1) {
            this.mode = 1;
            this.setUpdateRoot(0);
            this.updateObjects();
            this.repaint();
        }
        if (M_SAMEBINSIZE.equals(string) && this.mode != 2) {
            this.mode = 2;
            this.setUpdateRoot(0);
            this.updateObjects();
            this.repaint();
        }
        if (M_MULTIPLEBARCHARTS.equals(string) && this.mode != 3) {
            this.mode = 3;
            this.setUpdateRoot(0);
            this.updateObjects();
            this.repaint();
        }
        if (M_FLUCTUATION.equals(string) && this.mode != 4) {
            this.mode = 4;
            this.setUpdateRoot(0);
            this.updateObjects();
            this.repaint();
        }
        if (M_MAXLEVELUP.equals(string) && this.maxLevel > 1) {
            --this.maxLevel;
            this.updateObjects();
            this.setUpdateRoot(0);
            this.repaint();
        }
        if (M_MAXLEVELDOWN.equals(string) && this.maxLevel < this.vs) {
            ++this.maxLevel;
            this.updateObjects();
            this.setUpdateRoot(0);
            this.repaint();
        }
        if (M_CENSORUP.equals(string)) {
            ++this.censor;
            this.updateObjects();
            this.setUpdateRoot(0);
            this.repaint();
        }
        if (M_CENSORDOWN.equals(string) && this.censor > 0) {
            --this.censor;
            this.updateObjects();
            this.setUpdateRoot(0);
            this.repaint();
        }
        if (M_PERMUTELEFT.equals(string) && this.maxLevel != this.vs) {
            nArray = new int[this.vs];
            for (n2 = 0; n2 < this.maxLevel - 1; ++n2) {
                nArray[n2] = n2;
            }
            for (n2 = this.maxLevel - 1; n2 < this.vs; ++n2) {
                nArray[n2] = n2 + 1;
            }
            nArray[this.vs - 1] = this.maxLevel - 1;
            this.ft.permute(nArray);
            this.v = this.ft.getVars();
            this.updateObjects();
            this.setUpdateRoot(0);
            this.repaint();
        }
        if (M_PERMUTERIGHT.equals(string) && this.maxLevel != this.vs) {
            nArray = new int[this.vs];
            for (n2 = 0; n2 < this.maxLevel - 1; ++n2) {
                nArray[n2] = n2;
            }
            for (n2 = this.maxLevel; n2 < this.vs; ++n2) {
                nArray[n2] = n2 - 1;
            }
            nArray[this.maxLevel - 1] = this.vs - 1;
            this.ft.permute(nArray);
            this.v = this.ft.getVars();
            this.updateObjects();
            this.setUpdateRoot(0);
            this.repaint();
        }
        if ("setCB1".equals(string) && this.pp != null && this.pp.length > 0) {
            for (int i = 0; i < this.pp.length; ++i) {
                int[] nArray2 = ((PPrimBase)this.pp[i]).getCaseIDs();
                n = 0;
                if (nArray2 == null) continue;
                while (n < nArray2.length) {
                    this.m.setSec(nArray2[n++], i + 16);
                }
            }
            this.m.NotifyAll(new NotifyMsg(this, 4098));
        }
        if ("setCB64".equals(string) && this.pp != null && this.pp.length > 0) {
            for (int i = 0; i < this.pp.length; ++i) {
                int[] nArray3 = ((PPrimBase)this.pp[i]).getCaseIDs();
                n = 0;
                if (nArray3 == null) continue;
                while (n < nArray3.length) {
                    this.m.setSec(nArray3[n++], 64 + 64 * i / this.pp.length);
                }
            }
            this.m.NotifyAll(new NotifyMsg(this, 4098));
        }
        return null;
    }

    private void create(int n, int n2, int n3, int n4, String string) {
        int n5;
        int n6;
        int n7;
        int n8;
        int n9;
        double[] dArray = this.ft.getTable();
        double[] dArray2 = this.ft.getExp();
        int[] nArray = this.ft.getLevels();
        this.rects.clear();
        this.plevels = new int[this.vs];
        this.plevels[this.vs - 1] = 0;
        if (this.vs > 1) {
            this.plevels[this.vs - 2] = nArray[this.vs - 1];
        }
        for (n9 = this.vs - 3; n9 >= 0; --n9) {
            this.plevels[n9] = this.plevels[n9 + 1] * nArray[n9 + 1];
        }
        this.Gaps = new int[this.maxLevel + 2];
        this.aGap = new int[this.maxLevel + 2];
        int n10 = 0;
        this.subX = 0;
        int n11 = 1;
        int n12 = 1;
        for (n8 = 0; n8 < this.maxLevel; ++n8) {
            n9 = (this.maxLevel - n8) * 3;
            if (this.Dirs[n8] == 'x') {
                this.subX += n9 * (nArray[n8] - 1) * n12;
                n12 *= nArray[n8];
            } else {
                n10 += n9 * (nArray[n8] - 1) * n11;
                n11 *= nArray[n8];
            }
            this.Gaps[n8] = n9;
        }
        for (n8 = 0; n8 < this.maxLevel; ++n8) {
            n7 = this.Dirs[n8];
            int n13 = this.Gaps[n8];
            for (n6 = n8 + 1; n6 < this.maxLevel; ++n6) {
                if (this.Dirs[n6] != n7) continue;
                n5 = 1;
                for (int i = n8 + 1; i < n6; ++i) {
                    if (this.Dirs[i] != n7) continue;
                    n5 *= nArray[i];
                }
                n13 += this.Gaps[n6] * (n5 *= nArray[n6] - 1);
            }
            this.aGap[n8] = n13;
        }
        this.residSum = 0.0;
        for (n8 = 0; n8 < dArray.length; ++n8) {
            this.residSum += Math.abs(dArray[n8] - dArray2[n8]) / Math.sqrt(dArray2[n8]);
        }
        if (Math.abs(this.residSum) < 1.0E-7) {
            this.residSum = 1.0;
            for (n8 = 0; n8 < dArray.length; ++n8) {
                dArray2[n8] = dArray[n8];
            }
        }
        double[] dArray3 = new double[]{1.0};
        switch (this.mode) {
            case 0: {
                dArray3 = dArray;
                break;
            }
            case 1: {
                dArray3 = dArray2;
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                dArray3 = new double[dArray.length];
                for (n7 = 0; n7 < dArray3.length; ++n7) {
                    dArray3[n7] = 1.0;
                }
                break;
            }
        }
        this.combination = new int[this.vs];
        this.createMosaic(0, 0, dArray3, n, n2, Math.max(n3 - this.subX, 1), Math.max(n4 - n10, 1), string);
        if (this.Dirs[0] == 'x' && this.Dirs[1] == 'y' || this.Dirs[0] == 'y' && this.Dirs[1] == 'x') {
            this.x1x2[0] = n;
            this.x1x2[1] = n3;
            this.y1y2[0] = n2;
            this.y1y2[1] = n4;
        }
        if (this.mode == 3 || this.mode == 4) {
            double d = 0.0;
            n5 = this.rects.size();
            for (n6 = 0; n6 < n5; ++n6) {
                d = Math.max(d, ((PPrimMosaic)this.rects.get(n6)).getObs());
            }
            n5 = this.rects.size();
            for (n6 = 0; n6 < n5; ++n6) {
                int n14;
                int n15;
                PPrimMosaic pPrimMosaic = (PPrimMosaic)this.rects.get(n6);
                if (this.mode == 3) {
                    pPrimMosaic.setDir('y');
                    n15 = pPrimMosaic.r.width;
                    n14 = (int)((double)pPrimMosaic.r.height * (1.0 + (double)this.censor / 5.0) * pPrimMosaic.getObs() / d);
                } else {
                    n15 = (int)((double)pPrimMosaic.r.width * ((1.0 + (double)this.censor / 5.0) * Math.sqrt(pPrimMosaic.getObs() / d)));
                    n14 = (int)((double)pPrimMosaic.r.height * ((1.0 + (double)this.censor / 5.0) * Math.sqrt(pPrimMosaic.getObs() / d)));
                }
                if (n14 >= pPrimMosaic.r.height && n15 >= pPrimMosaic.r.width && this.censor > 0) {
                    pPrimMosaic.setCensored(true);
                    n14 = pPrimMosaic.r.height;
                    n15 = pPrimMosaic.r.width;
                }
                pPrimMosaic.changeDimension(n15, n14);
            }
        }
    }

    private void createMosaic(int n, int n2, double[] dArray, int n3, int n4, int n5, int n6, String string) {
        int n7;
        int n8;
        int n9;
        int n10 = this.vs;
        String string2 = this.v[n2].getName();
        Object[] objectArray = this.v[n2].getCategories();
        int n11 = objectArray.length;
        double[] dArray2 = this.ft.getExp();
        double[] dArray3 = this.ft.getTable();
        double[] dArray4 = new double[n11 + 1];
        double[] dArray5 = new double[n11 + 1];
        double[] dArray6 = new double[n11];
        double[] dArray7 = new double[n11];
        double d = 0.0;
        if (n2 < n10 - 1) {
            for (n9 = 0; n9 < n11; ++n9) {
                for (n8 = 0; n8 < this.plevels[n2]; ++n8) {
                    n7 = n + n9 * this.plevels[n2] + n8;
                    d += dArray[n7];
                    int n12 = n9 + 1;
                    dArray4[n12] = dArray4[n12] + dArray[n7];
                    int n13 = n9 + 1;
                    dArray5[n13] = dArray5[n13] + dArray3[n7];
                    int n14 = n9;
                    dArray6[n14] = dArray6[n14] + dArray2[n7];
                    int n15 = n9;
                    dArray7[n15] = dArray7[n15] + dArray3[n7];
                }
                int n16 = n9 + 1;
                dArray4[n16] = dArray4[n16] + dArray4[n9];
                int n17 = n9 + 1;
                dArray5[n17] = dArray5[n17] + dArray5[n9];
            }
        } else {
            for (n7 = 0; n7 < n11; ++n7) {
                d += dArray[n + n7];
                int n18 = n7 + 1;
                dArray4[n18] = dArray4[n18] + dArray[n + n7];
                int n19 = n7 + 1;
                dArray4[n19] = dArray4[n19] + dArray4[n7];
                int n20 = n7 + 1;
                dArray5[n20] = dArray5[n20] + dArray3[n + n7];
                int n21 = n7 + 1;
                dArray5[n21] = dArray5[n21] + dArray5[n7];
                int n22 = n7;
                dArray6[n22] = dArray6[n22] + dArray2[n + n7];
                int n23 = n7;
                dArray7[n23] = dArray7[n23] + dArray3[n + n7];
            }
        }
        n7 = this.aGap[n2];
        n9 = 0;
        n8 = 0;
        if (n2 > 0) {
            n9 = n2 == this.maxLevel - 1 ? 0 : (n2 == this.maxLevel - 2 ? 1 : this.aGap[n2] - this.Gaps[n2]);
            n8 = this.aGap[n2 - 1] - this.Gaps[n2 - 1];
        }
        int n24 = n5 - n3;
        int n25 = n6 - n4;
        if (d > 0.0) {
            for (int i = 0; i < n11; ++i) {
                int[] nArray;
                boolean bl;
                this.combination[n2] = i;
                if (n2 + 1 < this.combination.length) {
                    this.combination[n2 + 1] = -1;
                }
                String string3 = string + string2 + ": " + objectArray[i] + '\n';
                boolean bl2 = false;
                int n26 = 0;
                int n27 = 0;
                if (this.mode == 2 && Math.abs(dArray5[i + 1] - dArray5[i]) < 1.0E-4 || n2 == this.maxLevel - 1) {
                    bl2 = true;
                    for (int j = n2 + 1; j < this.maxLevel; ++j) {
                        if (this.Dirs[j] == 'x') {
                            n26 += this.aGap[j];
                            continue;
                        }
                        n27 += this.aGap[j];
                    }
                }
                boolean bl3 = bl = (nArray = this.ft.getMatchingCases(this.combination, this.maxLevel)).length == 0 && this.mode != 3 && this.mode != 4 && this.mode != 1 && this.mode != 2;
                if (bl2 || bl) {
                    PPrimMosaic pPrimMosaic = new PPrimMosaic();
                    pPrimMosaic.info = string3;
                    pPrimMosaic.setType(this.mode);
                    pPrimMosaic.ref = nArray;
                    pPrimMosaic.setExp(dArray6[i]);
                    pPrimMosaic.setScale(4.0 / this.residSum);
                    pPrimMosaic.setP(this.ft.getP());
                    if (this.Dirs[n2] == 'x') {
                        if (bl) {
                            pPrimMosaic.setBounds(n3 + (int)(dArray4[i] / d * (double)n24) + i * n7, n4, n9, n25 + n8);
                            pPrimMosaic.setObs(0.0);
                            pPrimMosaic.setDir('y');
                        } else {
                            pPrimMosaic.setBounds(n3 + (int)(dArray4[i] / d * (double)n24) + i * n7, n4, Math.max(1, (int)((dArray4[i + 1] - dArray4[i]) / d * (double)n24)) + n26, n6 - n4 + n27);
                            pPrimMosaic.setObs(dArray7[i]);
                            pPrimMosaic.setDir('y');
                        }
                    } else if (bl) {
                        pPrimMosaic.setBounds(n3, n4 + (int)(dArray4[i] / d * (double)n25) + i * n7, n24 + n8, n9);
                        pPrimMosaic.setObs(0.0);
                        pPrimMosaic.setDir('x');
                    } else {
                        pPrimMosaic.setBounds(n3, n4 + (int)(dArray4[i] / d * (double)n25) + i * n7, n5 - n3 + n26, Math.max(1, (int)((dArray4[i + 1] - dArray4[i]) / d * (double)n25)) + n27);
                        pPrimMosaic.setObs(dArray7[i]);
                        pPrimMosaic.setDir('x');
                    }
                    this.rects.add(pPrimMosaic);
                    continue;
                }
                if (this.Dirs[n2] == 'x') {
                    this.createMosaic(n + i * this.plevels[n2], n2 + 1, dArray, n3 + i * n7 + (int)(dArray4[i] / d * (double)n24), n4, n3 + i * n7 + Math.max((int)(dArray4[i] / d * (double)n24 + 1.0), (int)(dArray4[i + 1] / d * (double)n24)), n6, string3);
                    continue;
                }
                this.createMosaic(n + i * this.plevels[n2], n2 + 1, dArray, n3, n4 + i * n7 + (int)(dArray4[i] / d * (double)n25), n5, n4 + i * n7 + Math.max((int)(dArray4[i] / d * (double)n25 + 1.0), (int)(dArray4[i + 1] / d * (double)n25)), string3);
            }
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
        int n = keyEvent.getKeyCode();
        switch (n) {
            case 40: {
                if (keyEvent.isShiftDown()) {
                    this.run(this, M_CENSORDOWN);
                    break;
                }
                this.run(this, M_MAXLEVELDOWN);
                break;
            }
            case 38: {
                if (keyEvent.isShiftDown()) {
                    this.run(this, M_CENSORUP);
                    break;
                }
                this.run(this, M_MAXLEVELUP);
                break;
            }
            case 37: {
                this.run(this, M_PERMUTELEFT);
                break;
            }
            case 39: {
                this.run(this, M_PERMUTERIGHT);
            }
        }
        super.keyReleased(keyEvent);
    }

    public SVar getData(int n) {
        return n >= 0 && n < this.v.length ? this.v[n] : null;
    }

    public void Notifying(NotifyMsg notifyMsg, Object object, Vector vector) {
        if (!this.ignoreNotifications && notifyMsg.getMessageID() == 12291) {
            this.ft = new FrequencyTable(this.v);
        }
        super.Notifying(notifyMsg, object, vector);
    }

    public void rotate(int n) {
        if ((n & 1) == 1) {
            for (int i = this.maxLevel - 1; i < this.vs; ++i) {
                this.Dirs[i] = this.Dirs[i] == 'x' ? 121 : 120;
            }
            this.updateObjects();
            this.setUpdateRoot(0);
            this.repaint();
        }
    }

    public void paintBack(PoGraSS poGraSS) {
        int[] nArray = this.ft.getLevels();
        String[][] stringArray = this.ft.getLnames();
        int n = this.x1x2[0];
        int n2 = this.x1x2[1];
        int n3 = this.y1y2[0];
        int n4 = this.y1y2[1];
        this.startAddingLabels();
        boolean bl = false;
        if (this.Dirs[0] == 'x' && this.Dirs[1] == 'y' || this.Dirs[0] == 'y' && this.Dirs[1] == 'x') {
            for (int i = 0; i < Math.min(2, this.maxLevel); ++i) {
                int[] nArray2;
                if (this.Dirs[i] == 'x') {
                    nArray2 = new int[nArray[i]];
                    for (int j = 0; j < nArray[i]; ++j) {
                        nArray2[j] = (int)((double)n + (double)(n2 - n) / (double)nArray[i] * ((double)j + 0.5));
                    }
                    this.addXLabels(poGraSS, this.ax, stringArray[i], Math.max(n2 - this.subX, 1) / nArray[i], nArray2, false, true, true);
                    continue;
                }
                nArray2 = new int[nArray[i]];
                int[] nArray3 = new int[nArray[i]];
                for (int j = 0; j < nArray[i]; ++j) {
                    nArray2[j] = (int)((double)n3 + (double)(n4 - n3) / (double)nArray[i] * ((double)j + 0.5));
                    if (this.rotateYLabels) {
                        int n5 = j == 0 ? this.mTop : (int)((double)n3 + (double)(n4 - n3) / (double)nArray[i] * ((double)(j - 1) + 0.5));
                        int n6 = j == nArray[i] - 1 ? this.getBounds().height - this.mBottom : (int)((double)n3 + (double)(n4 - n3) / (double)nArray[i] * ((double)(j + 1) + 0.5));
                        nArray3[j] = 2 * Math.min(n6 - nArray2[j], nArray2[j] - n5);
                        continue;
                    }
                    nArray3[j] = this.mLeft - 5;
                }
                this.addYLabels(poGraSS, this.ay, stringArray[i], nArray3, nArray2, false, true);
            }
        }
        this.endAddingLabels();
    }
}

