/*
 * Decompiled with CFR 0.152.
 */
package org.rosuda.ibase.toolkit;

import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Canvas;
import java.awt.Choice;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Label;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import javax.swing.JColorChooser;
import org.rosuda.ibase.Common;
import org.rosuda.ibase.NotifyMsg;
import org.rosuda.ibase.toolkit.PGSCanvas;
import org.rosuda.util.GlobalConfig;
import org.rosuda.util.Tools;

public class PrefsColorFrame
extends Frame
implements WindowListener,
MouseListener,
ActionListener,
ItemListener {
    static final String M_SAVE = "Save";
    static final String M_APPLY = "Apply";
    static final String M_CLOSE = "Close";
    PrefCanvas pc;
    Choice cs;
    String[] schemes = new String[]{"KLIMT classic", "#ffffc0", "#ffffff", "#80ff80", "Terra di Siena", "#dfb860", "#c0c0c0", "#b46087", "Xtra red", "#ffffe0", "#c0c0c0", "#ff0000", null};
    static PrefsColorFrame last = null;

    public static PrefsColorFrame showPrefsDialog() {
        if (last == null) {
            last = new PrefsColorFrame();
        }
        last.setVisible(true);
        return last;
    }

    public PrefsColorFrame() {
        super("Preferences");
        this.setLayout(new BorderLayout());
        this.pc = new PrefCanvas();
        this.add(this.pc);
        this.pc.addMouseListener(this);
        Panel panel = new Panel();
        panel.setLayout(new BorderLayout());
        Panel panel2 = new Panel();
        panel.add((Component)panel2, "South");
        Panel panel3 = new Panel();
        panel.add(panel3);
        panel3.setLayout(new FlowLayout());
        panel3.add(new Label("Color scheme:"));
        this.cs = new Choice();
        panel3.add(this.cs);
        this.cs.add("Custom ...");
        int n = 0;
        while (this.schemes[n] != null) {
            this.cs.add(this.schemes[n]);
            if (this.schemes[n + 1].compareTo(Tools.color2hrgb(this.pc.c[0])) == 0 && this.schemes[n + 2].compareTo(Tools.color2hrgb(this.pc.c[1])) == 0 && this.schemes[n + 3].compareTo(Tools.color2hrgb(this.pc.c[2])) == 0) {
                this.cs.select(this.schemes[n]);
            }
            n += 4;
        }
        this.cs.addItemListener(this);
        panel2.setLayout(new FlowLayout());
        Button button = new Button(M_SAVE);
        panel2.add(button);
        button.addActionListener(this);
        button = new Button(M_APPLY);
        panel2.add(button);
        button.addActionListener(this);
        button = new Button(M_CLOSE);
        panel2.add(button);
        button.addActionListener(this);
        this.add((Component)panel, "South");
        this.pack();
        this.addWindowListener(this);
    }

    public void windowClosing(WindowEvent windowEvent) {
        this.setVisible(false);
    }

    public void windowClosed(WindowEvent windowEvent) {
    }

    public void windowOpened(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowActivated(WindowEvent windowEvent) {
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        String string = this.cs.getSelectedItem();
        int n = 0;
        while (this.schemes[n] != null) {
            if (this.schemes[n].equals(string)) {
                Color color;
                if ((color = Tools.hrgb2color(this.schemes[++n])) != null) {
                    this.pc.c[0] = color;
                }
                if ((color = Tools.hrgb2color(this.schemes[++n])) != null) {
                    this.pc.c[1] = color;
                }
                if ((color = Tools.hrgb2color(this.schemes[++n])) != null) {
                    this.pc.c[2] = color;
                }
                this.pc.repaint();
                return;
            }
            n += 4;
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        int n;
        Color color;
        int n2 = mouseEvent.getX();
        int n3 = mouseEvent.getY();
        if (n2 > 170 && n2 < 200 && n3 > 20 && n3 < 100 && (color = JColorChooser.showDialog(Common.mainFrame, "Choose color", this.pc.c[n = (n3 - 15) / 30])) != null) {
            this.cs.select("Custom ...");
            this.pc.c[n] = color;
            this.pc.repaint();
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void mouseDragged(MouseEvent mouseEvent) {
    }

    public void mouseMoved(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (M_CLOSE.equals(string)) {
            this.setVisible(false);
        }
        if (M_APPLY.equals(string) || M_SAVE.equals(string)) {
            Common.backgroundColor = this.pc.c[0];
            Common.objectsColor = this.pc.c[1];
            Common.selectColor = this.pc.c[2];
            PGSCanvas.getGlobalNotifier().NotifyAll(new NotifyMsg(this, 28672));
        }
        if (M_SAVE.equals(string)) {
            GlobalConfig globalConfig = GlobalConfig.getGlobalConfig();
            globalConfig.setParS("Common.color.background", Tools.color2hrgb(Common.backgroundColor));
            globalConfig.setParS("Common.color.objects", Tools.color2hrgb(Common.objectsColor));
            globalConfig.setParS("Common.color.select", Tools.color2hrgb(Common.selectColor));
            globalConfig.saveSettings();
            this.setVisible(false);
        }
    }

    class PrefCanvas
    extends Canvas {
        Color[] c;

        PrefCanvas() {
            this.setSize(250, 130);
            this.c = new Color[3];
            this.c[0] = Common.backgroundColor;
            this.c[1] = Common.objectsColor;
            this.c[2] = Common.selectColor;
        }

        public void paint(Graphics graphics) {
            graphics.setFont(new Font("SansSerif", 0, 11));
            graphics.drawString("background color:", 30, 35);
            graphics.drawString("objects color:", 30, 65);
            graphics.drawString("highlighting color:", 30, 95);
            graphics.setColor(this.c[0]);
            graphics.fillRect(170, 20, 30, 20);
            graphics.setColor(this.c[1]);
            graphics.fillRect(170, 50, 30, 20);
            graphics.setColor(this.c[2]);
            graphics.fillRect(170, 80, 30, 20);
            graphics.setColor(Color.black);
            graphics.drawRect(170, 20, 30, 20);
            graphics.drawRect(170, 50, 30, 20);
            graphics.drawRect(170, 80, 30, 20);
        }
    }
}

